/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.module;

import com.caucho.loader.module.ArtifactVersion;

public class ArtifactVersionRange {
    private final ArtifactVersion _min;
    private final boolean _isMinInclusive;
    private final ArtifactVersion _max;
    private final boolean _isMaxInclusive;
    private final boolean _isStrict;

    public ArtifactVersionRange(ArtifactVersion min, boolean isMinInclusive, ArtifactVersion max, boolean isMaxInclusive) {
        this._min = min;
        this._isMinInclusive = isMinInclusive;
        this._max = max;
        this._isMaxInclusive = isMaxInclusive;
        this._isStrict = true;
    }

    public ArtifactVersionRange(ArtifactVersion version) {
        this._min = version;
        this._isMinInclusive = true;
        this._max = version;
        this._isMaxInclusive = true;
        this._isStrict = false;
    }

    public static ArtifactVersionRange create(String value) {
        ArtifactVersion min = null;
        ArtifactVersion max = null;
        boolean isMinInclusive = true;
        boolean isMaxInclusive = true;
        boolean isStrict = false;
        if (value.startsWith("[")) {
            isMinInclusive = true;
            isStrict = true;
            value = value.substring(1);
        } else if (value.startsWith("(")) {
            isMinInclusive = false;
            isStrict = true;
            value = value.substring(1);
        }
        if (value.endsWith("]")) {
            isMaxInclusive = true;
            isStrict = true;
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith(")")) {
            isMaxInclusive = false;
            isStrict = true;
            value = value.substring(0, value.length() - 1);
        }
        value = value.trim();
        if (value.indexOf(44) >= 0) {
            isStrict = true;
            String[] values = value.split("[, ]+");
            String minValue = values[0].trim();
            String maxValue = values[1].trim();
            if (minValue.length() > 0) {
                min = ArtifactVersion.create(minValue);
            }
            if (maxValue.length() > 0) {
                max = ArtifactVersion.create(maxValue);
            }
        } else {
            min = max = ArtifactVersion.create(value);
        }
        if (isStrict) {
            return new ArtifactVersionRange(min, isMinInclusive, max, isMaxInclusive);
        }
        return new ArtifactVersionRange(min);
    }

    public boolean isMatch(ArtifactVersion version) {
        int cmp;
        if (!this._isStrict) {
            return true;
        }
        if (this._min != null && ((cmp = version.compareTo(this._min)) < 0 || cmp == 0 && !this._isMinInclusive)) {
            return false;
        }
        return this._max == null || (cmp = version.compareTo(this._max)) <= 0 && (cmp != 0 || this._isMaxInclusive);
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        if (this._isStrict) {
            if (this._isMinInclusive) {
                sb.append("[");
            } else {
                sb.append("(");
            }
        }
        if (this._min != null) {
            sb.append(this._min.toDebugString());
        }
        if (this._min != this._max) {
            sb.append(",");
            if (this._max != null) {
                sb.append(this._max.toDebugString());
            }
        }
        if (this._isStrict) {
            if (this._isMaxInclusive) {
                sb.append("]");
            } else {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (!this._isStrict) {
            sb.append("{");
        } else if (this._isMinInclusive) {
            sb.append("[");
        } else {
            sb.append("(");
        }
        if (this._min != null) {
            sb.append(this._min.toDebugString());
        }
        if (this._min != this._max) {
            sb.append(",");
            if (this._max != null) {
                sb.append(this._max.toDebugString());
            }
        }
        if (!this._isStrict) {
            sb.append("}");
        } else if (this._isMaxInclusive) {
            sb.append("]");
        } else {
            sb.append(")");
        }
        return sb.toString();
    }
}

