/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.LoggerMXBean;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerAdmin
extends AbstractManagedObject
implements LoggerMXBean {
    private static final L10N L = new L10N(LoggerAdmin.class);
    private final Logger _logger;
    private final ClassLoader _loader;

    LoggerAdmin(Logger logger) {
        this._logger = logger;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public String getName() {
        return this._logger.getName();
    }

    @Override
    public void setLevel(String level) {
        try {
            this._logger.setLevel(Level.parse(level.toUpperCase()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(L.l("'{0}' is an unknown log level.  Log levels are:\noff - disable logging\nsevere - severe errors only\nwarning - warnings\ninfo - information\nconfig - configuration\nfine - fine debugging\nfiner - finer debugging\nfinest - finest debugging\nall - all debugging", (Object)level));
        }
    }

    @Override
    public String getLevel() {
        return this._logger.getLevel().toString();
    }
}

