/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.naming.AbstractModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingException;

public class MemoryModel
extends AbstractModel {
    private HashMap<String, Object> _children = new HashMap(8);

    @Override
    protected AbstractModel create() {
        return new MemoryModel();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this._children.get(name);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this._children.put(name, obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this._children.remove(name);
    }

    @Override
    public AbstractModel createSubcontext(String name) throws NamingException {
        if (this._children.get(name) != null) {
            throw new NamingException("can't create subcontext: " + name + " " + this._children.get(name));
        }
        MemoryModel model = new MemoryModel();
        this._children.put(name, model);
        return model;
    }

    @Override
    public List list() {
        return new ArrayList<String>(this._children.keySet());
    }
}

