/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.naming.ContextImpl;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class QBindingEnumeration
implements NamingEnumeration {
    private static final Logger log = Logger.getLogger(QBindingEnumeration.class.getName());
    private static final L10N L = new L10N(QBindingEnumeration.class);
    private ContextImpl _context;
    private List _list;
    private int _index;

    QBindingEnumeration(ContextImpl context, List list) {
        this._context = context;
        this._list = list;
    }

    @Override
    public boolean hasMore() {
        return this._index < this._list.size();
    }

    public Binding next() throws NamingException {
        String name = (String)this._list.get(this._index++);
        Object obj = this._context.lookup(name);
        return new Binding(name, obj, true);
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore();
    }

    @Override
    public Object nextElement() {
        try {
            return this.next();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        ArrayList list = new ArrayList(this._list);
        Collections.sort(list);
        cb.append("QBindingEnumeration[");
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            if (i != 0) {
                cb.append(" ");
            }
            try {
                String valueName = String.valueOf(this._context.lookup(name));
                if (valueName.indexOf(64) >= 0) {
                    valueName = valueName.substring(0, valueName.indexOf(64));
                }
                cb.append("{" + name + ", " + valueName + "}");
                continue;
            }
            catch (Exception e) {
                cb.append("{" + name + ", " + e + "}");
            }
        }
        cb.append("]");
        return cb.toString();
    }
}

