/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StdoutStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.StringPath;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;

public class QuercusEngine {
    private QuercusContext _quercus = new QuercusContext();
    private OutputStream _out;
    private boolean _isInitialized;

    public void init() {
        if (this._isInitialized) {
            return;
        }
        this._quercus.init();
        this._quercus.start();
        this._isInitialized = true;
    }

    public QuercusContext getQuercus() {
        return this._quercus;
    }

    public void setIni(String name, String value) {
        this._quercus.setIni(name, value);
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }

    public Value executeFile(String filename) throws IOException {
        this.init();
        Path path = this._quercus.getPwd().lookup(filename);
        return this.execute(path);
    }

    public Value execute(String script) throws IOException {
        return this.execute(new StringPath(script));
    }

    public Value execute(Path path) throws IOException {
        WriteStream out;
        this.init();
        ReadStream reader = path.openRead();
        QuercusProgram program = QuercusParser.parse(this._quercus, null, reader);
        OutputStream os = this._out;
        if (os != null) {
            OutputStreamStream s = new OutputStreamStream(os);
            WriteStream ws = new WriteStream(s);
            ws.setNewlineString("\n");
            try {
                ws.setEncoding("iso-8859-1");
            }
            catch (Exception exception) {
                // empty catch block
            }
            out = ws;
        } else {
            out = new WriteStream(StdoutStream.create());
        }
        InterpretedPage page = new InterpretedPage(program);
        Env env = new Env(this._quercus, page, out, null, null);
        Value value = NullValue.NULL;
        try {
            env.start();
            value = program.execute(env);
        }
        catch (QuercusExitException quercusExitException) {
            // empty catch block
        }
        out.flushBuffer();
        out.free();
        if (os != null) {
            os.flush();
        }
        return value;
    }

    class OutputStreamStream
    extends StreamImpl {
        OutputStream _out;

        OutputStreamStream(OutputStream out) {
            this._out = out;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
            this._out.write(buffer, offset, length);
        }
    }
}

