/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArgGetFieldValue;
import com.caucho.quercus.env.ArgValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import java.io.Serializable;

public class ArgGetValue
extends ArgValue
implements Serializable {
    private final Value _obj;
    private final Value _index;

    public ArgGetValue(Value obj, Value index) {
        this._obj = obj;
        this._index = index;
    }

    @Override
    public Value toRefValue() {
        return this.toLocalValue();
    }

    @Override
    public Value getArg(Value index, boolean isTop) {
        return new ArgGetValue(this, index);
    }

    @Override
    public Value getFieldArg(Env env, StringValue index, boolean isTop) {
        return new ArgGetFieldValue(env, this, index);
    }

    @Override
    public Var toLocalVarDeclAsRef() {
        return this._obj.toAutoArray().getVar(this._index).toLocalVarDeclAsRef();
    }

    @Override
    public Value toAutoArray() {
        Value parent = this._obj.toAutoArray();
        Value value = parent.get(this._index);
        Value array = value.toAutoArray();
        if (array != value) {
            parent.put(this._index, array);
            value = array;
        }
        return value;
    }

    @Override
    public Value toAutoObject(Env env) {
        Value array = this._obj.toAutoArray();
        Value value = array.get(this._index);
        if (value.isNull()) {
            value = env.createObject();
            array.put(this._index, value);
        } else {
            Value obj = value.toAutoObject(env);
            if (obj != value) {
                array.put(this._index, obj);
            }
            value = obj;
        }
        return value;
    }

    @Override
    public Value toLocalValueReadOnly() {
        return this._obj.get(this._index);
    }

    @Override
    public Value toLocalValue() {
        return this._obj.get(this._index).copy();
    }

    @Override
    public Value toLocalRef() {
        return this._obj.get(this._index).copy();
    }

    public Object writeReplace() {
        return this.toValue();
    }
}

