/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaURLValue;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.program.JavaClassDef;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Logger;

public class BigDecimalValue
extends JavaValue {
    private static final Logger log = Logger.getLogger(JavaURLValue.class.getName());
    private final BigDecimal _val;

    public BigDecimalValue(Env env, BigDecimal val, JavaClassDef def) {
        super(env, val, def);
        this._val = val;
    }

    @Override
    public long toLong() {
        return this._val.longValue();
    }

    @Override
    public double toDouble() {
        return this._val.doubleValue();
    }

    @Override
    public BigDecimal toBigDecimal() {
        return this._val;
    }

    @Override
    public BigInteger toBigInteger() {
        return new BigInteger(this.toString());
    }

    @Override
    public boolean isDoubleConvertible() {
        return true;
    }

    @Override
    public boolean isLongConvertible() {
        return (double)this._val.longValue() == this._val.doubleValue();
    }

    @Override
    public String toString() {
        return "BigDecimal[" + this._val.doubleValue() + "]";
    }
}

