/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaInvoker;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.Arg;

public class CallbackFunction
extends Callback {
    private StringValue _funName;
    private AbstractFunction _fun;

    public CallbackFunction(Env env, StringValue funName) {
        this._funName = funName;
    }

    public CallbackFunction(AbstractFunction fun) {
        this._fun = fun;
    }

    public CallbackFunction(AbstractFunction fun, StringValue funName) {
        this._fun = fun;
        this._funName = funName;
    }

    protected void setFunction(AbstractFunction fun) {
        this._fun = fun;
    }

    @Override
    public boolean isValid(Env env) {
        if (this._fun != null) {
            return true;
        }
        this._fun = env.findFunction(this._funName);
        return this._fun != null;
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        CharSequence name = this._fun != null ? this._fun.getName() : this._funName;
        sb.append("S:");
        sb.append(name.length());
        sb.append(":\"");
        sb.append(name);
        sb.append("\";");
    }

    @Override
    public Value call(Env env) {
        return this.getFunction(env).call(env);
    }

    @Override
    public Value call(Env env, Value a1) {
        return this.getFunction(env).call(env, a1);
    }

    @Override
    public Value call(Env env, Value a1, Value a2) {
        return this.getFunction(env).call(env, a1, a2);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3) {
        return this.getFunction(env).call(env, a1, a2, a3);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this.getFunction(env).call(env, a1, a2, a3, a4);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.getFunction(env).call(env, a1, a2, a3, a4, a5);
    }

    @Override
    public Value call(Env env, Value[] args) {
        return this.getFunction(env).call(env, args);
    }

    @Override
    public String getCallbackName() {
        return this._funName.toString();
    }

    public AbstractFunction getFunction(Env env) {
        if (this._fun == null) {
            this._fun = env.getFunction(this._funName);
        }
        return this._fun;
    }

    @Override
    public boolean isInternal(Env env) {
        return this.getFunction(env) instanceof JavaInvoker;
    }

    @Override
    public String getDeclFileName(Env env) {
        return this.getFunction(env).getDeclFileName(env);
    }

    @Override
    public int getDeclStartLine(Env env) {
        return this.getFunction(env).getDeclStartLine(env);
    }

    @Override
    public int getDeclEndLine(Env env) {
        return this.getFunction(env).getDeclEndLine(env);
    }

    @Override
    public String getDeclComment(Env env) {
        return this.getFunction(env).getDeclComment(env);
    }

    @Override
    public boolean isReturnsReference(Env env) {
        return this.getFunction(env).isReturnsReference(env);
    }

    @Override
    public Arg[] getArgs(Env env) {
        return this.getFunction(env).getArgs(env);
    }

    @Override
    protected void varExportImpl(StringValue sb, int level) {
        sb.append("'' . \"\\0\" . '" + this._funName.substring(1) + "'");
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '[' + this._funName + ']';
    }
}

