/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LocaleInfo;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.QuercusLocale;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Locale;

public class DoubleValue
extends NumberValue
implements Serializable {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    private final double _value;

    public DoubleValue(double value) {
        this._value = value;
    }

    public static DoubleValue create(double value) {
        return new DoubleValue(value);
    }

    public static Value create(Number value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return new DoubleValue(value.doubleValue());
    }

    @Override
    public String getType() {
        return "double";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.DOUBLE;
    }

    @Override
    public boolean isDoubleConvertible() {
        return true;
    }

    @Override
    public boolean isLongConvertible() {
        return this._value == (double)((long)this._value);
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public boolean isScalar() {
        return true;
    }

    @Override
    public int toDoubleMarshalCost() {
        return 100;
    }

    @Override
    public int toLongMarshalCost() {
        return 300;
    }

    @Override
    public int toIntegerMarshalCost() {
        return 300;
    }

    @Override
    public int toShortMarshalCost() {
        return 300;
    }

    @Override
    public int toByteMarshalCost() {
        return 300;
    }

    @Override
    public boolean toBoolean() {
        return this._value != 0.0;
    }

    @Override
    public long toLong() {
        if (this._value > 9.223372036854776E18 || this._value < -9.223372036854776E18) {
            return 0L;
        }
        return (long)this._value;
    }

    @Override
    public double toDouble() {
        return this._value;
    }

    @Override
    public DoubleValue toDoubleValue() {
        return this;
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return env.createUnicodeBuilder().append(this.toString());
    }

    @Override
    public Value toKey() {
        return LongValue.create((long)this._value);
    }

    @Override
    public Object toJavaObject() {
        return new Double(this._value);
    }

    @Override
    public Value neg() {
        return new DoubleValue(-this._value);
    }

    @Override
    public Value pos() {
        return this;
    }

    @Override
    public Value add(Value rValue) {
        return new DoubleValue(this._value + rValue.toDouble());
    }

    @Override
    public Value add(long lValue) {
        return new DoubleValue((double)lValue + this._value);
    }

    @Override
    public Value addOne() {
        return new DoubleValue(this._value + 1.0);
    }

    @Override
    public Value subOne() {
        double next = this._value - 1.0;
        return new DoubleValue(next);
    }

    @Override
    public Value preincr() {
        return new DoubleValue(this._value + 1.0);
    }

    @Override
    public Value predecr() {
        return new DoubleValue(this._value - 1.0);
    }

    @Override
    public Value postincr() {
        return new DoubleValue(this._value + 1.0);
    }

    @Override
    public Value postdecr() {
        return new DoubleValue(this._value - 1.0);
    }

    @Override
    public Value increment(int incr) {
        return new DoubleValue(this._value + (double)incr);
    }

    @Override
    public Value mul(Value rValue) {
        return new DoubleValue(this._value * rValue.toDouble());
    }

    @Override
    public Value mul(long lValue) {
        return new DoubleValue((double)lValue * this._value);
    }

    @Override
    public Value abs() {
        if (this._value >= 0.0) {
            return this;
        }
        return DoubleValue.create(-this._value);
    }

    @Override
    public boolean eql(Value rValue) {
        if (!((rValue = rValue.toValue()) instanceof DoubleValue)) {
            return false;
        }
        double rDouble = ((DoubleValue)rValue)._value;
        return this._value == rDouble;
    }

    public String toString() {
        Env env = Env.getInstance();
        if (env != null) {
            return this.toString(env.getLocaleInfo().getNumeric());
        }
        return this.toString(LocaleInfo.getDefault().getNumeric());
    }

    @Override
    public StringValue toString(Env env) {
        String str = this.toString(env.getLocaleInfo().getNumeric());
        return env.createStringBuilder().append(str);
    }

    public String toString(QuercusLocale quercusLocale) {
        long longValue = (long)this._value;
        double abs = this._value < 0.0 ? -this._value : this._value;
        int exp = (int)Math.log10(abs);
        if ((double)longValue == this._value && exp < 18) {
            return String.valueOf(longValue);
        }
        Locale locale = quercusLocale.getLocale();
        if (-5 < exp && exp < 18) {
            char decimalSeparator = quercusLocale.getDecimalSeparator();
            int digits = 13 - exp;
            if (digits > 13) {
                digits = 13;
            } else if (digits < 0) {
                digits = 0;
            }
            String v = String.format(locale, "%." + digits + "f", this._value);
            int len = v.length();
            int nonzero = -1;
            boolean dot = false;
            --len;
            while (len >= 0) {
                char ch = v.charAt(len);
                if (ch == decimalSeparator) {
                    dot = true;
                }
                if (ch != '0' && nonzero < 0) {
                    nonzero = ch == decimalSeparator ? len - 1 : len;
                }
                --len;
            }
            if (dot && nonzero >= 0) {
                return v.substring(0, nonzero + 1);
            }
            return v;
        }
        return String.format(locale, "%.13E", this._value);
    }

    public Object toObject() {
        return this.toString();
    }

    @Override
    public void print(Env env) {
        env.print(this.toString());
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        sb.append("d:");
        sb.append(this._value);
        sb.append(";");
    }

    @Override
    protected void varExportImpl(StringValue sb, int level) {
        sb.append(this.toString());
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        if (this._value == 0.0) {
            out.print("DoubleValue.ZERO");
        } else if (this._value == Double.POSITIVE_INFINITY) {
            out.print("new DoubleValue(Double.POSITIVE_INFINITY)");
        } else if (this._value == Double.NEGATIVE_INFINITY) {
            out.print("new DoubleValue(Double.NEGATIVE_INFINITY)");
        } else {
            out.print("new DoubleValue(" + this._value + ")");
        }
    }

    @Override
    public int hashCode() {
        return (int)(37.0 + 65521.0 * this._value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleValue)) {
            return false;
        }
        DoubleValue value = (DoubleValue)o;
        return this._value == value._value;
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print("float(" + this.toString() + ")");
    }

    private Object readResolve() {
        if (this._value == 0.0) {
            return ZERO;
        }
        return this;
    }
}

