/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvVar;
import com.caucho.quercus.env.ImportMap;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.program.ClassDef;
import com.caucho.util.IntMap;
import com.caucho.vfs.Path;
import java.util.HashMap;
import java.util.Map;

public class SaveState {
    private AbstractFunction[] _fun;
    private ClassDef[] _classDef;
    private QuercusClass[] _qClass;
    private Value[] _const;
    private IntMap _staticNameMap = new IntMap();
    private Value[] _staticValues;
    private IntMap _globalNameMap = new IntMap();
    private Value[] _globalValues;
    private Map<Path, QuercusPage> _includeMap;
    private ImportMap _importMap;

    SaveState(Env env, AbstractFunction[] fun, ClassDef[] classDef, QuercusClass[] qClass, Value[] constants, Map<StringValue, Var> staticMap, Map<StringValue, EnvVar> globalMap, HashMap<Path, QuercusPage> includeMap, ImportMap importMap) {
        this._fun = new AbstractFunction[fun.length];
        System.arraycopy(fun, 0, this._fun, 0, fun.length);
        this._classDef = new ClassDef[classDef.length];
        System.arraycopy(classDef, 0, this._classDef, 0, classDef.length);
        this._qClass = new QuercusClass[qClass.length];
        System.arraycopy(qClass, 0, this._qClass, 0, qClass.length);
        this._const = new Value[constants.length];
        System.arraycopy(constants, 0, this._const, 0, constants.length);
        this.saveStatics(env, staticMap);
        this.saveGlobals(env, globalMap);
        this._includeMap = new HashMap<Path, QuercusPage>(includeMap);
        if (importMap != null) {
            this._importMap = importMap.copy();
        }
    }

    public AbstractFunction[] getFunctionList() {
        return this._fun;
    }

    public ClassDef[] getClassDefList() {
        return this._classDef;
    }

    public QuercusClass[] getQuercusClassList() {
        return this._qClass;
    }

    public Value[] getConstantList() {
        return this._const;
    }

    public IntMap getStaticNameMap() {
        return this._staticNameMap;
    }

    public Value[] getStaticList() {
        return this._staticValues;
    }

    public IntMap getGlobalNameMap() {
        return this._globalNameMap;
    }

    public Value[] getGlobalList() {
        return this._globalValues;
    }

    public Map<Path, QuercusPage> getIncludeMap() {
        return this._includeMap;
    }

    public ImportMap getImportMap() {
        return this._importMap;
    }

    public boolean isModified() {
        return false;
    }

    private void saveStatics(Env env, Map<StringValue, Var> staticMap) {
        this._staticValues = new Value[staticMap.size()];
        for (Map.Entry<StringValue, Var> entry : staticMap.entrySet()) {
            int id = this.addStaticName(entry.getKey());
            this._staticValues[id] = entry.getValue().toValue().copy(env);
        }
    }

    private void saveGlobals(Env env, Map<StringValue, EnvVar> globalMap) {
        this._globalValues = new Value[globalMap.size()];
        for (Map.Entry<StringValue, EnvVar> entry : globalMap.entrySet()) {
            if (env.isSpecialVar(entry.getKey())) continue;
            EnvVar envVar = entry.getValue();
            int id = this.addGlobalName(entry.getKey());
            this._globalValues[id] = envVar.get().copy(env);
        }
    }

    private int addStaticName(StringValue name) {
        int id = this._staticNameMap.get(name);
        if (id >= 0) {
            return id;
        }
        id = this._staticNameMap.size();
        this._staticNameMap.put(name, id);
        return id;
    }

    private int addGlobalName(StringValue name) {
        int id = this._globalNameMap.get(name);
        if (id >= 0) {
            return id;
        }
        id = this._globalNameMap.size();
        this._globalNameMap.put(name, id);
        return id;
    }
}

