/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.IdentityHashMap;

public abstract class UnicodeValue
extends StringValue {
    protected UnicodeValue() {
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append("unicode(");
        sb.append(length);
        sb.append(") \"");
        int appendLength = length > 256 ? 256 : length;
        for (int i = 0; i < appendLength; ++i) {
            sb.append(this.charAt(i));
        }
        if (length > 256) {
            sb.append(" ...");
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int length = this.length();
        if (length < 0) {
            length = 0;
        }
        out.print("unicode(");
        out.print(length);
        out.print(") \"");
        for (int i = 0; i < length; ++i) {
            out.print(this.charAt(i));
        }
        out.print("\"");
    }

    @Override
    public StringValue toUnicodeValue() {
        return this;
    }

    @Override
    public StringValue toUnicodeValue(Env env) {
        return this;
    }

    @Override
    public StringValue toUnicodeValue(Env env, String charset) {
        return this;
    }

    @Override
    public StringValue toStringBuilder() {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        sb.append(this);
        return sb;
    }

    @Override
    public boolean isUnicode() {
        return true;
    }

    @Override
    public int toUnicodeValueMarshalCost() {
        return 0;
    }

    @Override
    public InputStream toInputStream() {
        try {
            String charset = Env.getInstance().getRuntimeEncoding();
            return new ByteArrayInputStream(this.toString().getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    @Override
    public Reader toReader(String charset) {
        return this.toSimpleReader();
    }

    @Override
    public String toString(String charset) {
        return this.toString();
    }
}

