/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.CallExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.util.ArrayList;

public class CallVarExpr
extends Expr {
    private static final L10N L = new L10N(CallExpr.class);
    protected final Expr _name;
    protected final Expr[] _args;

    public CallVarExpr(Location location, Expr name, ArrayList<Expr> args) {
        super(location);
        this._name = name;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public CallVarExpr(Location location, Expr name, Expr[] args) {
        super(location);
        this._name = name;
        this._args = args;
    }

    public CallVarExpr(Expr name, ArrayList<Expr> args) {
        this(Location.UNKNOWN, name, args);
    }

    public CallVarExpr(Expr name, Expr[] args) {
        this(Location.UNKNOWN, name, args);
    }

    @Override
    public Expr createRef(QuercusParser parser) {
        return parser.getFactory().createRef(this);
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return this;
    }

    @Override
    public Value eval(Env env) {
        return this.evalImpl(env, false, false);
    }

    @Override
    public Value evalRef(Env env) {
        return this.evalImpl(env, true, false);
    }

    @Override
    public Value evalCopy(Env env) {
        return this.evalImpl(env, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evalImpl(Env env, boolean isRef, boolean isCopy) {
        Value value = this._name.eval(env);
        Value[] args = CallVarExpr.evalArgs(env, this._args);
        env.pushCall(this, NullValue.NULL, null);
        try {
            env.checkTimeout();
            if (isRef) {
                Value value2 = value.callRef(env, args);
                return value2;
            }
            if (isCopy) {
                Value value3 = value.call(env, args).copyReturn();
                return value3;
            }
            Value value4 = value.call(env, args).toValue();
            return value4;
        }
        finally {
            env.popCall();
        }
    }

    @Override
    public String toString() {
        return this._name + "()";
    }
}

