/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.ClassMethodExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

public class ClassConstExpr
extends Expr {
    private static final L10N L = new L10N(ClassMethodExpr.class);
    protected final String _className;
    protected final StringValue _name;

    public ClassConstExpr(Location location, String className, StringValue name) {
        super(location);
        this._className = className.intern();
        this._name = name;
    }

    public ClassConstExpr(String className, StringValue name) {
        this._className = className.intern();
        this._name = name;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createClassMethodCall(location, this._className, this._name, args);
    }

    @Override
    public Value eval(Env env) {
        return env.getClass(this._className).getConstant(env, this._name);
    }

    @Override
    public String toString() {
        return this._className + "::" + this._name;
    }
}

