/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractMethodExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;
import java.util.ArrayList;

public class ClassConstructExpr
extends AbstractMethodExpr {
    private static final L10N L = new L10N(ClassConstructExpr.class);
    protected final String _className;
    protected final Expr[] _args;
    protected boolean _isMethod;

    public ClassConstructExpr(Location location, String className, ArrayList<Expr> args) {
        super(location);
        this._className = className.intern();
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public ClassConstructExpr(Location location, String className, Expr[] args) {
        super(location);
        this._className = className.intern();
        this._args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        Value oldThis;
        QuercusClass cl = env.findClass(this._className);
        if (cl == null) {
            env.error(L.l("no matching class {0}", (Object)this._className), this.getLocation());
        }
        Value[] values = ClassConstructExpr.evalArgs(env, this._args);
        Value qThis = oldThis = env.getThis();
        env.pushCall(this, cl, values);
        try {
            env.checkTimeout();
            Value value = cl.callConstructor(env, qThis, values);
            return value;
        }
        finally {
            env.popCall();
            env.setThis(oldThis);
        }
    }

    @Override
    public String toString() {
        return this._className + "::__construct()";
    }
}

