/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.util.L10N;
import java.util.ArrayList;

public class ClassConstructorExpr
extends Expr {
    private static final L10N L = new L10N(ClassConstructorExpr.class);
    protected final String _className;
    protected final StringValue _nameV;
    protected final Expr[] _args;

    public ClassConstructorExpr(Location location, String className, StringValue nameV, ArrayList<Expr> args) {
        super(location);
        this._className = className.intern();
        this._nameV = nameV;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public ClassConstructorExpr(Location location, String className, StringValue nameV, Expr[] args) {
        super(location);
        this._className = className.intern();
        this._nameV = nameV;
        this._args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        QuercusClass cl = env.findClass(this._className);
        if (cl == null) {
            throw env.createErrorException(L.l("{0} is an unknown class", (Object)this._className));
        }
        StringValue nameV = this._nameV;
        AbstractFunction fun = cl.getFunction(nameV);
        Value[] values = ClassConstructorExpr.evalArgs(env, this._args);
        Value qThis = env.getThis();
        env.pushCall(this, qThis, values);
        try {
            env.checkTimeout();
            Value value = cl.callMethod(env, qThis, nameV, nameV.hashCode(), values);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    @Override
    public String toString() {
        return this._className + "::" + this._nameV + "()";
    }
}

