/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.ClassVirtualMethodExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

public class ClassVirtualConstExpr
extends Expr {
    private static final L10N L = new L10N(ClassVirtualMethodExpr.class);
    protected final StringValue _name;

    public ClassVirtualConstExpr(Location location, StringValue name) {
        super(location);
        this._name = name;
    }

    public ClassVirtualConstExpr(StringValue name) {
        this._name = name;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createClassVirtualMethodCall(location, this._name, args);
    }

    @Override
    public Value eval(Env env) {
        return env.getCallingClass().getConstant(env, this._name);
    }

    @Override
    public String toString() {
        return "static::" + this._name;
    }
}

