/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;

public class ConditionalExpr
extends Expr {
    protected final Expr _test;
    protected final Expr _trueExpr;
    protected final Expr _falseExpr;

    public ConditionalExpr(Location location, Expr test, Expr trueExpr, Expr falseExpr) {
        super(location);
        this._test = test;
        this._trueExpr = trueExpr;
        this._falseExpr = falseExpr;
    }

    public ConditionalExpr(Expr test, Expr trueExpr, Expr falseExpr) {
        this._test = test;
        this._trueExpr = trueExpr;
        this._falseExpr = falseExpr;
    }

    @Override
    public Value eval(Env env) {
        if (this._test.evalBoolean(env)) {
            return this._trueExpr.eval(env);
        }
        return this._falseExpr.eval(env);
    }

    @Override
    public boolean evalBoolean(Env env) {
        if (this._test.evalBoolean(env)) {
            return this._trueExpr.evalBoolean(env);
        }
        return this._falseExpr.evalBoolean(env);
    }

    @Override
    public Value evalCopy(Env env) {
        if (this._test.evalBoolean(env)) {
            return this._trueExpr.evalCopy(env);
        }
        return this._falseExpr.evalCopy(env);
    }

    @Override
    public String toString() {
        return "(" + this._test + " ? " + this._trueExpr + " : " + this._falseExpr + ")";
    }
}

