/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;

public class LiteralExpr
extends Expr {
    private final Value _value;

    public LiteralExpr(Value value) {
        this._value = value;
    }

    protected Value getValue() {
        return this._value;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isTrue() {
        if (this._value == BooleanValue.TRUE) {
            return true;
        }
        if (this._value instanceof LongValue) {
            return this._value.toLong() != 0L;
        }
        return false;
    }

    @Override
    public boolean isFalse() {
        if (this._value == BooleanValue.FALSE) {
            return true;
        }
        if (this._value instanceof LongValue) {
            return this._value.toLong() == 0L;
        }
        return false;
    }

    @Override
    public boolean isLong() {
        return this._value.isLongConvertible();
    }

    @Override
    public boolean isDouble() {
        return this._value.isDoubleConvertible();
    }

    @Override
    public boolean isBoolean() {
        return this._value.isBoolean();
    }

    @Override
    public Value evalConstant() {
        return this._value;
    }

    @Override
    public Value eval(Env env) {
        return this._value;
    }

    @Override
    public QuercusClass evalQuercusClass(Env env) {
        String className = this.evalString(env);
        return env.getClass(className);
    }

    @Override
    public String toString() {
        return this._value.toString();
    }
}

