/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;

public class LiteralStringExpr
extends Expr {
    protected final StringValue _value;

    public LiteralStringExpr(StringValue value) {
        this._value = value;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public Expr createClassConst(QuercusParser parser, StringValue name) {
        ExprFactory factory = parser.getExprFactory();
        String className = this._value.toString();
        if ("self".equals(className)) {
            className = parser.getSelfClassName();
            return factory.createClassConst(className, name);
        }
        if ("parent".equals(className)) {
            className = parser.getParentClassName();
            return factory.createClassConst(className, name);
        }
        if ("static".equals(className)) {
            return factory.createClassVirtualConst(name);
        }
        return factory.createClassConst(className, name);
    }

    @Override
    public Expr createClassConst(QuercusParser parser, Expr name) {
        ExprFactory factory = parser.getExprFactory();
        String className = this._value.toString();
        if ("self".equals(className)) {
            className = parser.getSelfClassName();
            return factory.createClassConst(className, name);
        }
        if ("parent".equals(className)) {
            className = parser.getParentClassName();
            return factory.createClassConst(className, name);
        }
        if ("static".equals(className)) {
            return factory.createClassVirtualConst(name);
        }
        return factory.createClassConst(className, name);
    }

    @Override
    public Value evalConstant() {
        return this._value;
    }

    @Override
    public Value eval(Env env) {
        return this._value;
    }

    @Override
    public StringValue evalStringValue(Env env) {
        return this._value;
    }

    @Override
    public String toString() {
        return "\"" + this._value + "\"";
    }
}

