/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.util.L10N;

public class ThisExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(Expr.class);
    protected final InterpretedClassDef _classDef;

    public ThisExpr(InterpretedClassDef classDef) {
        this._classDef = classDef;
    }

    public InterpretedClassDef getClassDef() {
        return this._classDef;
    }

    @Override
    public Expr createFieldGet(ExprFactory factory, Location location, StringValue name) {
        return factory.createThisField(location, this, name);
    }

    @Override
    public Expr createFieldGet(ExprFactory factory, Location location, Expr name) {
        return factory.createThisField(location, this, name);
    }

    @Override
    public Value eval(Env env) {
        return env.getThis();
    }

    @Override
    public Value evalArg(Env env, boolean isTop) {
        return env.getThis();
    }

    @Override
    public Var evalVar(Env env) {
        return env.getThis().toVar();
    }

    @Override
    public Value evalAssignValue(Env env, Value value) {
        env.error(L.l("can't assign $this"), this.getLocation());
        return value;
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        env.error(L.l("can't assign $this"), this.getLocation());
        return value;
    }

    @Override
    public void evalUnset(Env env) {
        env.error(L.l("can't unset $this"), this.getLocation());
    }

    @Override
    public QuercusClass evalQuercusClass(Env env) {
        return env.getThis().getQuercusClass();
    }

    @Override
    public String toString() {
        return "$this";
    }
}

