/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractUnaryExpr;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;

public class UnaryRefExpr
extends AbstractUnaryExpr {
    public UnaryRefExpr(Location location, Expr expr) {
        super(location, expr);
    }

    public UnaryRefExpr(Expr expr) {
        super(expr);
    }

    @Override
    public boolean isRef() {
        return true;
    }

    @Override
    public Expr createAssignFrom(QuercusParser parser, AbstractVarExpr leftHandSide) {
        ExprFactory factory = parser.getExprFactory();
        return factory.createAssignRef(leftHandSide, this._expr);
    }

    @Override
    public Value eval(Env env) {
        Var value = this.getExpr().evalVar(env);
        return ((Value)value).toRef();
    }

    @Override
    public Value evalArg(Env env, boolean isTop) {
        Var value = this.getExpr().evalVar(env);
        return ((Value)value).toArgRef();
    }

    @Override
    public Var evalVar(Env env) {
        Var value = this.getExpr().evalVar(env);
        return value;
    }

    @Override
    public String toString() {
        return this._expr.toString();
    }
}

