/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;

public class CtypeModule
extends AbstractQuercusModule {
    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"ctype"};
    }

    public static boolean ctype_alnum(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.isalnum(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.isalnum(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ctype_alpha(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.isalpha(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.isalpha(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ctype_cntrl(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.iscntrl(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.iscntrl(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ctype_digit(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.isdigit(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.isdigit(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ctype_graph(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.isgraph(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.isgraph(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ctype_lower(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.islower(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.islower(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ctype_print(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.isprint(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.isprint(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ctype_punct(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.ispunct(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.ispunct(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ctype_space(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.isspace(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.isspace(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ctype_upper(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.isupper(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.isupper(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean ctype_xdigit(Value value) {
        if (value instanceof LongValue) {
            return CtypeModule.isxdigit(value.toInt());
        }
        if (value instanceof StringValue) {
            String string = value.toString();
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (CtypeModule.isxdigit(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isalnum(int ch) {
        return 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57;
    }

    public static boolean isalpha(int ch) {
        return 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90;
    }

    public static boolean iscntrl(int ch) {
        return 0 <= ch && ch <= 31 || ch == 127;
    }

    public static boolean isdigit(int ch) {
        return 48 <= ch && ch <= 57;
    }

    public static boolean isgraph(int ch) {
        return 33 <= ch && ch <= 126;
    }

    public static boolean islower(int ch) {
        return 97 <= ch && ch <= 122;
    }

    public static boolean isprint(int ch) {
        return 32 <= ch && ch <= 126;
    }

    public static boolean ispunct(int ch) {
        return CtypeModule.isprint(ch) && !CtypeModule.isspace(ch) && !CtypeModule.isalnum(ch);
    }

    public static boolean isspace(int ch) {
        return ch == 32 || 9 <= ch && ch <= 13;
    }

    public static boolean isupper(int ch) {
        return 65 <= ch && ch <= 90;
    }

    public static boolean isxdigit(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }
}

