/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.FileInput;
import com.caucho.quercus.lib.file.FileOutput;
import com.caucho.quercus.lib.file.ReadStreamInput;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcOpenInput
extends ReadStreamInput
implements EnvCleanup {
    private static final Logger log = Logger.getLogger(FileInput.class.getName());
    private Env _env;
    private InputStream _in;
    private FileOutput _out;

    public ProcOpenInput(Env env, InputStream in) throws IOException {
        super(env);
        this._env = env;
        this._in = in;
        env.addCleanup(this);
        this.init(new ReadStream(new VfsStream(in, null)));
    }

    public ProcOpenInput(Env env, InputStream in, FileOutput out) {
        super(env);
        this._env = env;
        this._in = in;
        env.removeCleanup(out);
        this._out = out;
        env.addCleanup(this);
        this.init(new ReadStream(new VfsStream(in, null)));
    }

    @Override
    public BinaryInput openCopy() throws IOException {
        return new ProcOpenInput(this._env, this._in, this._out);
    }

    public long getLength() {
        return 0L;
    }

    @Override
    public String toString() {
        if (this._out != null) {
            return "ProcOpenInput[" + this._out + "]";
        }
        return "ProcOpenInput[pipe]";
    }

    @Override
    public void close() {
        this._env.removeCleanup(this);
        this.cleanup();
    }

    @Override
    public void cleanup() {
        try {
            if (this._out != null) {
                int ch;
                while ((ch = this._in.read()) >= 0) {
                    this._out.write(ch);
                }
                this._out.close();
            }
            this._in.close();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            this._env.warning(e);
        }
    }
}

