/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.PostBody;
import com.caucho.quercus.lib.file.BinaryInput;
import java.io.IOException;
import java.io.OutputStream;

public class UserBody
extends PostBody {
    private final CurlResource _curl;
    private Callable _callback;
    private Value _fileV;
    private long _length;

    public UserBody(Env env, CurlResource curl, Callable callback, BinaryInput file, long length) {
        this._curl = curl;
        this._callback = callback;
        this._fileV = env.wrapJava(file);
        this._length = length;
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    @Override
    public long getContentLength() {
        return this._length;
    }

    @Override
    public boolean isChunked() {
        return this._length < 0L;
    }

    @Override
    public void writeTo(Env env, OutputStream os) throws IOException {
        StringValue str;
        int count;
        long length = this._length;
        LongValue lengthV = LongValue.create(length);
        for (long totalWritten = 0L; totalWritten < length && (count = (str = this._callback.call(env, this._curl, this._fileV, lengthV).toStringValue(env)).length()) != 0; totalWritten += (long)count) {
            str.writeTo(os);
        }
    }
}

