/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.dom;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.dom.DOMDocument;
import com.caucho.quercus.lib.dom.DOMNode;
import com.caucho.quercus.lib.dom.DOMNodeList;
import com.caucho.util.LruCache;
import com.caucho.xpath.Expr;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMXPath {
    private DOMNamespaceContext _context;
    private DOMDocument _document;

    public static DOMXPath __construct(Env env, DOMDocument document) {
        return new DOMXPath(env, document);
    }

    private DOMXPath(Env env, DOMDocument document) {
        this._document = document;
    }

    public Object evaluate(Env env, String expression) {
        Node node = this._document.getDelegate();
        NodeList nodeList = this.query(env, expression, node);
        if (nodeList.getLength() == 1) {
            return this._document.wrap(nodeList.item(0));
        }
        return this._document.wrap(nodeList);
    }

    public DOMNodeList query(Env env, String expression, @Optional DOMNode<Node> contextNode) {
        Node node = contextNode != null ? contextNode.getDelegate() : this._document.getDelegate();
        NodeList nodeList = this.query(env, expression, node);
        return (DOMNodeList)this._document.wrap(nodeList);
    }

    private NodeList query2(Env env, String pattern, Node node) {
        try {
            Expr expr = com.caucho.xpath.XPath.parseExpr(pattern);
            return (NodeList)expr.evalObject(node);
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    private NodeList query(Env env, String pattern, Node node) {
        try {
            if (this._context == null) {
                QuercusContext quercus = env.getQuercus();
                ExpressionCache cache = (ExpressionCache)quercus.getSpecial("caucho.domxpath.cache");
                if (cache == null) {
                    cache = new ExpressionCache();
                    quercus.setSpecial("caucho.domxpath.cache", cache);
                }
                XPathExpression expr = cache.compile(pattern);
                NodeList nodeList = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
                cache.free(pattern, expr);
                return nodeList;
            }
            XPath xpath = (XPath)env.getSpecialValue("caucho.domxpath.xpath");
            if (xpath == null) {
                XPathFactory factory = XPathFactory.newInstance();
                xpath = factory.newXPath();
                env.setSpecialValue("caucho.domxpath.xpath", xpath);
            }
            xpath.setNamespaceContext(this._context);
            XPathExpression expr = xpath.compile(pattern);
            NodeList nodeList = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
            return nodeList;
        }
        catch (XPathExpressionException e) {
            throw new QuercusModuleException(e);
        }
    }

    public boolean registerNamespace(String prefix, String namespaceURI) {
        if (this._context == null) {
            this._context = new DOMNamespaceContext();
        }
        this._context.addNamespace(prefix, namespaceURI);
        return true;
    }

    static class ExpressionEntry {
        private XPathExpression _expr;

        ExpressionEntry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        XPathExpression allocate() {
            ExpressionEntry expressionEntry = this;
            synchronized (expressionEntry) {
                XPathExpression expr = this._expr;
                this._expr = null;
                return expr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void free(XPathExpression expr) {
            ExpressionEntry expressionEntry = this;
            synchronized (expressionEntry) {
                this._expr = expr;
            }
        }
    }

    static class ExpressionCache {
        private final XPathFactory _factory = XPathFactory.newInstance();
        private final LruCache<String, ExpressionEntry> _xpathCache = new LruCache(1024);

        ExpressionCache() {
        }

        XPathExpression compile(String pattern) throws XPathExpressionException {
            ExpressionEntry entry = this._xpathCache.get(pattern);
            XPathExpression expr = null;
            if (entry != null) {
                expr = entry.allocate();
            }
            if (expr == null) {
                XPath xpath = this._factory.newXPath();
                expr = xpath.compile(pattern);
            }
            return expr;
        }

        void free(String pattern, XPathExpression expr) {
            ExpressionEntry entry = this._xpathCache.get(pattern);
            if (entry == null) {
                entry = new ExpressionEntry();
                this._xpathCache.put(pattern, entry);
            }
            entry.free(expr);
        }
    }

    public class DOMNamespaceContext
    implements NamespaceContext {
        private HashMap<String, LinkedHashSet<String>> _namespaceMap = new HashMap();

        protected void addNamespace(String prefix, String namespaceURI) {
            LinkedHashSet<String> list = this._namespaceMap.get(namespaceURI);
            if (list == null) {
                list = new LinkedHashSet();
                this._namespaceMap.put(namespaceURI, list);
            }
            list.add(prefix);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            for (Map.Entry<String, LinkedHashSet<String>> entry : this._namespaceMap.entrySet()) {
                if (!entry.getValue().contains(prefix)) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            Iterator<String> iter = this.getPrefixes(namespaceURI);
            if (iter != null) {
                return iter.next();
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            LinkedHashSet<String> prefixList = this._namespaceMap.get(namespaceURI);
            if (prefixList != null) {
                return prefixList.iterator();
            }
            return null;
        }
    }
}

