/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.file.AbstractBinaryInputOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayBinaryStream
extends AbstractBinaryInputOutput {
    private byte[] _buffer = new byte[4096];
    private int _pos;
    private int _length;

    public ByteArrayBinaryStream(Env env) {
        super(env);
        ByteArrayBinaryInputStream is = new ByteArrayBinaryInputStream();
        ByteArrayBinaryOutputStream os = new ByteArrayBinaryOutputStream();
        this.init(is, os);
    }

    @Override
    public long getPosition() {
        return this._pos;
    }

    @Override
    public boolean setPosition(long pos) {
        if ((long)this._length < pos) {
            return false;
        }
        this._pos = (int)pos;
        return true;
    }

    @Override
    public void unread() throws IOException {
        if (this._pos == 0) {
            throw new IOException("no more bytes to unread");
        }
        --this._pos;
    }

    @Override
    public boolean isEOF() {
        return this._length <= this._pos;
    }

    private void ensureCapacity(int size) {
        if (size <= this._buffer.length) {
            return;
        }
        int newSize = Math.max(this._buffer.length * 2, size);
        byte[] buffer = new byte[newSize];
        System.arraycopy(this._buffer, 0, buffer, 0, this._length);
        this._buffer = buffer;
    }

    class ByteArrayBinaryOutputStream
    extends OutputStream {
        @Override
        public void write(byte[] buffer, int offset, int length) {
            ByteArrayBinaryStream.this.ensureCapacity(ByteArrayBinaryStream.this._pos + length);
            System.arraycopy(buffer, offset, ByteArrayBinaryStream.this._buffer, ByteArrayBinaryStream.this._pos, length);
            ByteArrayBinaryStream.this._pos = ByteArrayBinaryStream.this._pos + length;
            if (ByteArrayBinaryStream.this._length < ByteArrayBinaryStream.this._pos) {
                ByteArrayBinaryStream.this._length = ByteArrayBinaryStream.this._pos;
            }
        }

        @Override
        public void write(int ch) {
            ByteArrayBinaryStream.this.ensureCapacity(ByteArrayBinaryStream.this._pos + 1);
            ((ByteArrayBinaryStream)ByteArrayBinaryStream.this)._buffer[((ByteArrayBinaryStream)ByteArrayBinaryStream.this)._pos++] = (byte)ch;
            if (ByteArrayBinaryStream.this._length < ByteArrayBinaryStream.this._pos) {
                ByteArrayBinaryStream.this._length = ByteArrayBinaryStream.this._pos;
            }
        }
    }

    class ByteArrayBinaryInputStream
    extends InputStream {
        @Override
        public int read(byte[] buffer, int offset, int length) {
            int len = Math.min(ByteArrayBinaryStream.this._length - ByteArrayBinaryStream.this._pos, length);
            System.arraycopy(ByteArrayBinaryStream.this._buffer, ByteArrayBinaryStream.this._pos, buffer, offset, len);
            ByteArrayBinaryStream.this._pos = ByteArrayBinaryStream.this._pos + len;
            return len;
        }

        @Override
        public int read() {
            if (ByteArrayBinaryStream.this._pos < ByteArrayBinaryStream.this._length) {
                return ByteArrayBinaryStream.this._buffer[ByteArrayBinaryStream.this._pos++] & 0xFF;
            }
            return -1;
        }
    }
}

