/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.FileModule;
import java.io.IOException;

public class LineReader {
    private Boolean _isMacLineEnding;

    public LineReader(Env env) {
        this(FileModule.INI_AUTO_DETECT_LINE_ENDINGS.getAsBoolean(env));
    }

    private LineReader(boolean isAutoDetectLineEndings) {
        if (!isAutoDetectLineEndings) {
            this._isMacLineEnding = Boolean.FALSE;
        }
    }

    public StringValue readLine(Env env, BinaryInput input, long length) throws IOException {
        int ch;
        StringValue sb = env.createBinaryBuilder();
        while (length > 0L && (ch = input.read()) >= 0) {
            if (ch == 10) {
                sb.appendByte((byte)ch);
                if (this._isMacLineEnding == null) {
                    this._isMacLineEnding = false;
                }
                if (!this._isMacLineEnding.booleanValue()) {
                    break;
                }
            } else if (ch == 13) {
                sb.appendByte(13);
                int ch2 = input.read();
                if (ch2 == 10) {
                    if (this._isMacLineEnding == null) {
                        this._isMacLineEnding = false;
                    }
                    if (this._isMacLineEnding.booleanValue()) {
                        input.unread();
                        break;
                    }
                    sb.appendByte(10);
                    break;
                }
                input.unread();
                if (this._isMacLineEnding == null) {
                    this._isMacLineEnding = true;
                }
                if (this._isMacLineEnding.booleanValue()) {
                    return sb;
                }
            } else {
                sb.appendByte((byte)ch);
            }
            --length;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb;
    }
}

