/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.lib.regexp.RegexpNode;
import com.caucho.util.IntSet;
import java.util.HashMap;

class RegexpSet {
    static final int BITSET_CHARS = 128;
    static RegexpSet SPACE = null;
    static RegexpSet WORD = null;
    static RegexpSet DIGIT = null;
    static RegexpSet DOT = null;
    static RegexpSet PALNUM = null;
    static RegexpSet PALPHA = null;
    static RegexpSet PASCII = null;
    static RegexpSet PBLANK = null;
    static RegexpSet PCNTRL = null;
    static RegexpSet PDIGIT = null;
    static RegexpSet PGRAPH = null;
    static RegexpSet PLOWER = null;
    static RegexpSet PPRINT = null;
    static RegexpSet PPUNCT = null;
    static RegexpSet PSPACE = null;
    static RegexpSet PUPPER = null;
    static RegexpSet PXDIGIT = null;
    static HashMap<String, RegexpSet> CLASS_MAP = null;
    boolean[] _bitset = new boolean[128];
    IntSet _range;

    RegexpSet() {
        this._range = new IntSet();
    }

    RegexpSet(RegexpSet old) {
        System.arraycopy(old._bitset, 0, this._bitset, 0, this._bitset.length);
        this._range = (IntSet)old._range.clone();
    }

    void mergeOr(RegexpSet b) {
        for (int i = 0; i < 128; ++i) {
            this._bitset[i] = this._bitset[i] || b._bitset[i];
        }
        this._range.union(b._range);
    }

    void mergeOrInv(RegexpSet b) {
        for (int i = 0; i < 128; ++i) {
            this._bitset[i] = this._bitset[i] || !b._bitset[i];
        }
        this._range.unionNegate(b._range, 0, 1048575);
    }

    void setRange(int low, int high) {
        if (low > high || low < 0) {
            throw new RuntimeException("Range out of range (" + low + ", " + high + ")");
        }
        if (low < 128) {
            for (int i = low; i < Math.min(high + 1, 128); ++i) {
                this._bitset[i] = true;
            }
            if (high < 128) {
                return;
            }
            low = 128;
        }
        this._range.union(low, high);
    }

    boolean mergeOverlap(RegexpSet next) {
        boolean isDisjoint = true;
        for (int i = 0; i < 128; ++i) {
            this._bitset[i] = this._bitset[i] & next._bitset[i];
            if (!this._bitset[i]) continue;
            isDisjoint = false;
        }
        if (this._range.intersection(next._range)) {
            isDisjoint = false;
        }
        return isDisjoint;
    }

    void difference(RegexpSet next) {
        for (int i = 0; i < 128; ++i) {
            this._bitset[i] = this._bitset[i] & !next._bitset[i];
        }
        this._range.difference(next._range);
    }

    boolean match(int ch) {
        if (ch < 0) {
            return false;
        }
        if (ch < 128) {
            return this._bitset[ch];
        }
        return this._range.contains(ch);
    }

    RegexpNode createNode() {
        if (this._range.size() == 0) {
            return new RegexpNode.AsciiSet(this._bitset);
        }
        return new RegexpNode.Set(this._bitset, this._range);
    }

    RegexpNode createNotNode() {
        if (this._range.size() == 0) {
            return new RegexpNode.AsciiNotSet(this._bitset);
        }
        return new RegexpNode.NotSet(this._bitset, this._range);
    }

    int getSize() {
        return this._range.size();
    }

    static {
        SPACE = new RegexpSet();
        SPACE.setRange(32, 32);
        SPACE.setRange(9, 10);
        SPACE.setRange(12, 13);
        DOT = new RegexpSet();
        DOT.setRange(10, 10);
        DIGIT = new RegexpSet();
        DIGIT.setRange(48, 57);
        WORD = new RegexpSet();
        WORD.setRange(97, 122);
        WORD.setRange(65, 90);
        WORD.setRange(48, 57);
        WORD.setRange(95, 95);
        PASCII = new RegexpSet();
        PASCII.setRange(0, 127);
        PASCII.setRange(129, 135);
        PASCII.setRange(137, 151);
        PASCII.setRange(154, 255);
        PBLANK = new RegexpSet();
        PBLANK.setRange(32, 32);
        PBLANK.setRange(9, 9);
        PBLANK.setRange(160, 160);
        PCNTRL = new RegexpSet();
        PCNTRL.setRange(0, 31);
        PCNTRL.setRange(127, 127);
        PCNTRL.setRange(129, 129);
        PCNTRL.setRange(141, 141);
        PCNTRL.setRange(143, 144);
        PCNTRL.setRange(157, 157);
        PDIGIT = new RegexpSet();
        PDIGIT.setRange(48, 57);
        PDIGIT.setRange(178, 179);
        PDIGIT.setRange(185, 185);
        PLOWER = new RegexpSet();
        PLOWER.setRange(97, 122);
        PLOWER.setRange(131, 131);
        PLOWER.setRange(154, 154);
        PLOWER.setRange(156, 156);
        PLOWER.setRange(158, 158);
        PLOWER.setRange(170, 170);
        PLOWER.setRange(181, 181);
        PLOWER.setRange(186, 186);
        PLOWER.setRange(223, 246);
        PLOWER.setRange(248, 255);
        PSPACE = new RegexpSet();
        PSPACE.setRange(32, 32);
        PSPACE.setRange(9, 13);
        PSPACE.setRange(160, 160);
        PUPPER = new RegexpSet();
        PUPPER.setRange(65, 90);
        PUPPER.setRange(138, 138);
        PUPPER.setRange(140, 140);
        PUPPER.setRange(142, 142);
        PUPPER.setRange(159, 159);
        PUPPER.setRange(192, 214);
        PUPPER.setRange(216, 222);
        PXDIGIT = new RegexpSet();
        PXDIGIT.setRange(48, 57);
        PXDIGIT.setRange(65, 70);
        PXDIGIT.setRange(97, 102);
        PALPHA = new RegexpSet();
        PALPHA.mergeOr(PLOWER);
        PALPHA.mergeOr(PUPPER);
        PALNUM = new RegexpSet();
        PALNUM.mergeOr(PALPHA);
        PALNUM.mergeOr(PDIGIT);
        PPUNCT = new RegexpSet();
        PPUNCT.setRange(33, 47);
        PPUNCT.setRange(58, 64);
        PPUNCT.setRange(91, 96);
        PPUNCT.setRange(123, 126);
        PPUNCT.setRange(130, 130);
        PPUNCT.setRange(132, 135);
        PPUNCT.setRange(137, 137);
        PPUNCT.setRange(139, 139);
        PPUNCT.setRange(145, 151);
        PPUNCT.setRange(155, 155);
        PPUNCT.setRange(161, 191);
        PPUNCT.setRange(215, 215);
        PPUNCT.setRange(247, 247);
        PGRAPH = new RegexpSet();
        PGRAPH.mergeOr(PALNUM);
        PGRAPH.mergeOr(PPUNCT);
        PPRINT = new RegexpSet();
        PPRINT.mergeOr(PGRAPH);
        PPRINT.setRange(32, 32);
        PPRINT.setRange(9, 9);
        PPRINT.setRange(160, 160);
        CLASS_MAP = new HashMap();
        CLASS_MAP.put("alnum", PALNUM);
        CLASS_MAP.put("alpha", PALPHA);
        CLASS_MAP.put("ascii", PASCII);
        CLASS_MAP.put("blank", PBLANK);
        CLASS_MAP.put("cntrl", PCNTRL);
        CLASS_MAP.put("digit", PDIGIT);
        CLASS_MAP.put("graph", PGRAPH);
        CLASS_MAP.put("lower", PLOWER);
        CLASS_MAP.put("print", PPRINT);
        CLASS_MAP.put("punct", PPUNCT);
        CLASS_MAP.put("space", PSPACE);
        CLASS_MAP.put("upper", PUPPER);
        CLASS_MAP.put("xdigit", PXDIGIT);
    }
}

