/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.AttributeView;
import com.caucho.quercus.lib.simplexml.IteratorIndex;
import com.caucho.quercus.lib.simplexml.SimpleView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;

public class AttributeListView
extends SimpleView {
    private final ArrayList<AttributeView> _attrList;

    public AttributeListView(Document doc, ArrayList<AttributeView> attrList) {
        super(doc);
        this._attrList = attrList;
    }

    @Override
    public String getNodeName() {
        if (this._attrList.size() > 0) {
            return this._attrList.get(0).getNodeName();
        }
        return "";
    }

    @Override
    public SimpleView getIndex(Env env, Value indexV) {
        if (indexV.isString()) {
            String nodeName = indexV.toString();
            for (AttributeView view : this._attrList) {
                if (!view.getNodeName().equals(nodeName)) continue;
                return view;
            }
            return null;
        }
        int index = indexV.toInt();
        if (index < this._attrList.size()) {
            return this._attrList.get(index);
        }
        return null;
    }

    @Override
    public SimpleView setIndex(Env env, Value indexV, Value value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleView getField(Env env, Value indexV) {
        String name = indexV.toString();
        for (AttributeView attr : this._attrList) {
            if (!attr.getNodeName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public SimpleView setField(Env env, Value indexV, Value value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Env env) {
        return this._attrList.get(0).toString(env);
    }

    @Override
    public boolean issetField(Env env, String name) {
        for (SimpleView simpleView : this._attrList) {
            if (!simpleView.getNodeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Map.Entry<IteratorIndex, SimpleView>> getIterator() {
        LinkedHashMap<IteratorIndex, SimpleView> map = new LinkedHashMap<IteratorIndex, SimpleView>();
        for (int i = 0; i < this._attrList.size(); ++i) {
            SimpleView view = this._attrList.get(i);
            map.put(IteratorIndex.create(view.getNodeName()), view);
        }
        return map.entrySet().iterator();
    }

    @Override
    public Set<Map.Entry<Value, Value>> getEntrySet(Env env, QuercusClass cls) {
        LinkedHashMap<StringValue, ArrayValueImpl> map = new LinkedHashMap<StringValue, ArrayValueImpl>();
        if (this._attrList.size() > 0) {
            ArrayValueImpl array = new ArrayValueImpl();
            for (AttributeView view : this._attrList) {
                String name = view.getNodeName();
                String value = view.getNodeValue();
                array.put(env.createString(name), env.createString(value));
            }
            map.put(env.createString("@attributes"), array);
        }
        return map.entrySet();
    }

    @Override
    public boolean toXml(Env env, StringBuilder sb) {
        if (this._attrList.size() > 0) {
            SimpleView attr = this._attrList.get(0);
            attr.toXml(env, sb);
            return true;
        }
        return false;
    }

    @Override
    public Value toDumpValue(Env env, QuercusClass cls, boolean isChildren) {
        ObjectValue obj = env.createObject();
        obj.setClassName(cls.getName());
        Set<Map.Entry<Value, Value>> set = this.getEntrySet(env, cls);
        for (Map.Entry<Value, Value> entry : set) {
            obj.putField(env, entry.getKey().toString(), entry.getValue());
        }
        return obj;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._attrList + "]";
    }
}

