/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.xml;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ResourceType;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.CallbackObjectMethod;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.xml.XmlModule;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@ResourceType(value="xml")
public class Xml {
    private static final Logger log = Logger.getLogger(Xml.class.getName());
    private static final L10N L = new L10N(Xml.class);
    private boolean _xmlOptionCaseFolding = true;
    private String _outputEncoding;
    private long _xmlOptionSkipTagstart = 0L;
    private boolean _xmlOptionSkipWhite = false;
    private String _separator;
    private int _errorCode = 0;
    private String _errorString;
    private Callable _startElementHandler;
    private Callable _endElementHandler;
    private Callable _characterDataHandler;
    private Callable _processingInstructionHandler;
    private Callable _defaultHandler;
    private Callable _startNamespaceDeclHandler;
    private Callable _endNamespaceDeclHandler;
    private Callable _notationDeclHandler;
    private Callable _unparsedEntityDeclHandler;
    private Value _parser;
    private ObjectValue _obj;
    SAXParserFactory _factory = SAXParserFactory.newInstance();
    private StringValue _xmlString;
    private XmlHandler _xmlHandler;

    public Xml(Env env, String outputEncoding, String separator) {
        this._outputEncoding = outputEncoding;
        this._parser = env.wrapJava(this);
        this._separator = separator;
    }

    public int getLine() {
        if (this._xmlHandler != null) {
            return this._xmlHandler.getLine();
        }
        return 0;
    }

    public int getColumn() {
        if (this._xmlHandler != null) {
            return this._xmlHandler.getColumn();
        }
        return 0;
    }

    public int getByteIndex() {
        return 0;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public String getErrorString() {
        return this._errorString;
    }

    public boolean xml_set_element_handler(Env env, Value startElementHandler, Value endElementHandler) {
        if (this._obj == null) {
            if (!startElementHandler.isEmpty()) {
                this._startElementHandler = startElementHandler.toCallable(env, false);
            }
            if (!endElementHandler.isEmpty()) {
                this._endElementHandler = endElementHandler.toCallable(env, false);
            }
        } else {
            CallbackObjectMethod callback;
            StringValue name;
            if (!startElementHandler.isEmpty()) {
                name = startElementHandler.toStringValue(env);
                callback = new CallbackObjectMethod(this._obj, name);
                this._startElementHandler = callback;
            }
            if (!endElementHandler.isEmpty()) {
                name = endElementHandler.toStringValue(env);
                callback = new CallbackObjectMethod(this._obj, name);
                this._endElementHandler = callback;
            }
        }
        return true;
    }

    public boolean xml_set_character_data_handler(Env env, Value handler) {
        if (this._obj == null) {
            this._characterDataHandler = handler.toCallable(env, false);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(handler);
            this._characterDataHandler = ((Value)value).toCallable(env, false);
        }
        return true;
    }

    public boolean xml_set_default_handler(Env env, Value handler) {
        if (this._obj == null) {
            this._defaultHandler = handler.toCallable(env, false);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(handler);
            this._defaultHandler = ((Value)value).toCallable(env, false);
        }
        return true;
    }

    public boolean xml_set_processing_instruction_handler(Env env, Value processingInstructionHandler) {
        if (this._obj == null) {
            this._processingInstructionHandler = processingInstructionHandler.toCallable(env, false);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(processingInstructionHandler);
            this._processingInstructionHandler = ((Value)value).toCallable(env, false);
        }
        return true;
    }

    public boolean xml_set_start_namespace_decl_handler(Env env, Value startNamespaceDeclHandler) {
        if (this._obj == null) {
            this._startNamespaceDeclHandler = startNamespaceDeclHandler.toCallable(env, false);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(startNamespaceDeclHandler);
            this._startNamespaceDeclHandler = ((Value)value).toCallable(env, false);
        }
        return true;
    }

    public boolean xml_set_unparsed_entity_decl_handler(Env env, Value handler) {
        if (this._obj == null) {
            this._unparsedEntityDeclHandler = handler.toCallable(env, false);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(handler);
            this._unparsedEntityDeclHandler = ((Value)value).toCallable(env, false);
        }
        return true;
    }

    public boolean xml_set_end_namespace_decl_handler(Env env, Value endNamespaceDeclHandler) {
        if (this._obj == null) {
            this._endNamespaceDeclHandler = endNamespaceDeclHandler.toCallable(env, false);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(endNamespaceDeclHandler);
            this._endNamespaceDeclHandler = ((Value)value).toCallable(env, false);
        }
        return true;
    }

    public boolean xml_set_notation_decl_handler(Env env, Value handler) {
        if (this._obj == null) {
            this._notationDeclHandler = handler.toCallable(env, false);
        } else {
            ArrayValueImpl value = new ArrayValueImpl();
            ((Value)value).put(this._obj);
            ((Value)value).put(handler);
            this._notationDeclHandler = ((Value)value).toCallable(env, false);
        }
        return true;
    }

    public boolean xml_set_object(ObjectValue obj) {
        if (obj == null) {
            return false;
        }
        this._obj = obj;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int xml_parse(Env env, StringValue data, @Optional(value="true") boolean isFinal) throws Exception {
        if (this._xmlString == null) {
            this._xmlString = data.createStringBuilder();
        }
        this._xmlString.append(data);
        if (isFinal) {
            InputSource is = this._xmlString.isUnicode() ? new InputSource(this._xmlString.toReader("utf-8")) : new InputSource(this._xmlString.toInputStream());
            try {
                this._errorCode = 0;
                this._errorString = null;
                this._xmlHandler = new XmlHandler(env);
                SAXParser saxParser = this._factory.newSAXParser();
                saxParser.parse(is, (DefaultHandler)this._xmlHandler);
            }
            catch (SAXParseException e) {
                XmlModule.recordError(env, 3, 0, e.getColumnNumber(), e.toString(), "", e.getLineNumber());
                this._errorCode = 2;
                this._errorString = e.toString();
                log.log(Level.FINE, e.getMessage(), e);
                int n = 0;
                return n;
            }
            catch (Exception e) {
                XmlModule.recordError(env, 3, 0, 0, e.toString(), "", 0);
                this._errorCode = 2;
                this._errorString = e.toString();
                log.log(Level.FINE, e.toString(), e);
                int n = 0;
                return n;
            }
            finally {
                this._xmlHandler = null;
            }
        }
        return 1;
    }

    public int xml_parse_into_struct(Env env, StringValue data, @Reference Value valsV, @Optional @Reference Value indexV) throws Exception {
        ArrayValueImpl valueArray = new ArrayValueImpl();
        ArrayValueImpl indexArray = new ArrayValueImpl();
        valsV.set(valueArray);
        indexV.set(indexArray);
        if (data == null || data.length() == 0) {
            return 0;
        }
        if (this._xmlString == null) {
            this._xmlString = data.toStringBuilder(env);
        }
        InputSource is = this._xmlString.isUnicode() ? new InputSource(this._xmlString.toReader("utf-8")) : new InputSource(this._xmlString.toInputStream());
        try {
            SAXParser saxParser = this._factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)new StructHandler(env, valueArray, indexArray));
        }
        catch (SAXException e) {
            this._errorCode = 2;
            this._errorString = e.toString();
            log.log(Level.FINE, e.toString(), e);
            return 0;
        }
        catch (IOException e) {
            this._errorCode = 2;
            this._errorString = e.toString();
            log.log(Level.FINE, e.toString(), e);
            return 0;
        }
        catch (Exception e) {
            this._errorCode = 2;
            this._errorString = e.toString();
            log.log(Level.FINE, e.toString(), e);
            return 0;
        }
        return 1;
    }

    public boolean xml_parser_set_option(int option, Value value) {
        switch (option) {
            case 0: {
                this._xmlOptionCaseFolding = value.toBoolean();
                return true;
            }
            case 1: {
                this._xmlOptionSkipTagstart = value.toLong();
                return true;
            }
            case 2: {
                this._xmlOptionSkipWhite = value.toBoolean();
                return true;
            }
            case 3: {
                this._outputEncoding = value.toString();
                return true;
            }
        }
        return false;
    }

    public Value xml_parser_get_option(Env env, int option) {
        switch (option) {
            case 0: {
                return this._xmlOptionCaseFolding ? LongValue.ONE : LongValue.ZERO;
            }
            case 1: {
                return LongValue.create(this._xmlOptionSkipTagstart);
            }
            case 2: {
                return this._xmlOptionSkipWhite ? LongValue.ONE : LongValue.ZERO;
            }
            case 3: {
                return env.createString(this._outputEncoding);
            }
        }
        return BooleanValue.FALSE;
    }

    public String toString() {
        return "Xml[]";
    }

    class XmlHandler
    extends DefaultHandler {
        private Locator _locator;
        private Env _env;

        XmlHandler(Env env) {
            this._env = env;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
        }

        public int getLine() {
            if (this._locator != null) {
                return this._locator.getLineNumber();
            }
            return 0;
        }

        public int getColumn() {
            if (this._locator != null) {
                return this._locator.getColumnNumber();
            }
            return 0;
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            Value[] args = new Value[3];
            args[0] = Xml.this._parser;
            String eName = lName;
            if (eName.length() == 0) {
                eName = qName;
            }
            if (Xml.this._startElementHandler == null && Xml.this._defaultHandler != null) {
                StringValue sb = this._env.createStringBuilder();
                sb.append("<");
                sb.append(eName);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (aName.length() == 0) {
                        aName = attrs.getQName(i);
                    }
                    sb.append(' ');
                    sb.append(aName);
                    sb.append('=');
                    sb.append('\"');
                    sb.append(attrs.getValue(i));
                    sb.append('\"');
                }
                sb.append(">");
                Xml.this._defaultHandler.call(this._env, Xml.this._parser, sb);
                return;
            }
            if (Xml.this._xmlOptionCaseFolding) {
                eName = eName.toUpperCase(Locale.ENGLISH);
            }
            args[1] = this._env.createString(eName);
            args[2] = new ArrayValueImpl();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                if (Xml.this._xmlOptionCaseFolding) {
                    aName = aName.toUpperCase(Locale.ENGLISH);
                }
                args[2].put(this._env.createString(aName), this._env.createString(attrs.getValue(i)));
            }
            try {
                if (Xml.this._startElementHandler != null) {
                    Xml.this._startElementHandler.call(this._env, args);
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " startElement " + qName);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            try {
                String eName = sName;
                if (eName.length() == 0) {
                    eName = qName;
                }
                if (Xml.this._endElementHandler != null) {
                    if (Xml.this._xmlOptionCaseFolding) {
                        eName = eName.toUpperCase(Locale.ENGLISH);
                    }
                    Xml.this._endElementHandler.call(this._env, Xml.this._parser, this._env.createString(eName));
                } else if (Xml.this._defaultHandler != null) {
                    StringValue sb = this._env.createStringBuilder();
                    sb.append("</");
                    sb.append(eName);
                    sb.append(">");
                    Xml.this._defaultHandler.call(this._env, Xml.this._parser, sb);
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " endElement " + sName);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        @Override
        public void characters(char[] buf, int start, int length) throws SAXException {
            StringValue value;
            if (this._env.isUnicodeSemantics()) {
                value = this._env.createString(buf, start, length);
            } else {
                byte[] bytes;
                String encoding = Xml.this._outputEncoding;
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                String s = new String(buf, start, length);
                try {
                    bytes = s.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new QuercusException(e);
                }
                value = this._env.createStringBuilder();
                value.append(bytes);
            }
            try {
                if (Xml.this._characterDataHandler != null) {
                    Xml.this._characterDataHandler.call(this._env, Xml.this._parser, value);
                } else if (Xml.this._defaultHandler != null) {
                    Xml.this._defaultHandler.call(this._env, Xml.this._parser, value);
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " characters '" + value + "'");
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            try {
                if (Xml.this._processingInstructionHandler != null) {
                    Xml.this._processingInstructionHandler.call(this._env, Xml.this._parser, this._env.createString(target), this._env.createString(data));
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " processingInstruction " + target);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            try {
                if (Xml.this._startNamespaceDeclHandler != null) {
                    Xml.this._startNamespaceDeclHandler.call(this._env, this._env.createString(prefix), this._env.createString(uri));
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " startPrefixMapping " + prefix + " " + uri);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            try {
                if (Xml.this._endNamespaceDeclHandler != null) {
                    Xml.this._endNamespaceDeclHandler.call(this._env, this._env.createString(prefix));
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " endPrefixMapping");
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        @Override
        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            try {
                if (Xml.this._notationDeclHandler != null) {
                    Xml.this._notationDeclHandler.call(this._env, Xml.this._parser, this._env.createString(name), this._env.createString(""), this._env.createString(systemId), this._env.createString(publicId));
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " notation " + name);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }

        @Override
        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            Value[] args = new Value[]{Xml.this._parser, this._env.createString(name), this._env.createString(""), this._env.createString(systemId), this._env.createString(publicId), this._env.createString(notationName)};
            try {
                if (Xml.this._unparsedEntityDeclHandler != null) {
                    Xml.this._unparsedEntityDeclHandler.call(this._env, args);
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " unparsedEntity " + name);
                }
            }
            catch (Exception t) {
                log.log(Level.FINE, t.toString(), t);
                throw new SAXException(L.l(t.getMessage()));
            }
        }
    }

    class StructHandler
    extends DefaultHandler {
        private ArrayValueImpl _valueArray;
        private ArrayValueImpl _indexArray;
        private int _level = 1;
        private HashMap<Integer, String> _paramHashMap = new HashMap();
        private HashMap<StringValue, ArrayValueImpl> _indexArrayHashMap = new HashMap();
        private ArrayList<StringValue> _indexArrayKeys = new ArrayList();
        private boolean _isComplete = true;
        private boolean _isOutside = true;
        private int _valueArrayIndex = 0;
        private Locator _locator;
        private Env _env;

        public StructHandler(Env env, ArrayValueImpl valueArray, ArrayValueImpl indexArray) {
            this._env = env;
            this._valueArray = valueArray;
            this._indexArray = indexArray;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
        }

        public int getLine() {
            if (this._locator != null) {
                return this._locator.getLineNumber();
            }
            return 0;
        }

        public int getColumn() {
            if (this._locator != null) {
                return this._locator.getColumnNumber();
            }
            return 0;
        }

        private ArrayValueImpl createAttributeArray(Env env, Attributes attrs) {
            ArrayValueImpl result = new ArrayValueImpl();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                if (Xml.this._xmlOptionCaseFolding) {
                    aName = aName.toUpperCase(Locale.ENGLISH);
                }
                result.put(env.createString(aName), env.createString(attrs.getValue(i)));
            }
            return result;
        }

        @Override
        public void endDocument() throws SAXException {
            for (StringValue sv : this._indexArrayKeys) {
                this._indexArray.put(sv, this._indexArrayHashMap.get(sv));
            }
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            ArrayValueImpl elementArray = new ArrayValueImpl();
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (Xml.this._xmlOptionCaseFolding) {
                eName = eName.toUpperCase(Locale.ENGLISH);
            }
            ((Value)elementArray).put(this._env.createString("tag"), this._env.createString(eName));
            ((Value)elementArray).put(this._env.createString("type"), this._env.createString("open"));
            ((Value)elementArray).put(this._env.createString("level"), LongValue.create(this._level));
            this._paramHashMap.put(this._level, eName);
            if (attrs.getLength() > 0) {
                ((Value)elementArray).put(this._env.createString("attributes"), this.createAttributeArray(this._env, attrs));
            }
            this._valueArray.put(LongValue.create(this._valueArrayIndex), elementArray);
            this.addToIndexArrayHashMap(eName);
            ++this._valueArrayIndex;
            ++this._level;
            this._isComplete = true;
            this._isOutside = false;
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            --this._level;
            if (this._isComplete) {
                Value elementArray = this._valueArray.get(LongValue.create(this._valueArrayIndex - 1));
                elementArray.put(this._env.createString("type"), this._env.createString("complete"));
            } else {
                ArrayValueImpl elementArray = new ArrayValueImpl();
                String eName = sName;
                if ("".equals(sName)) {
                    eName = qName;
                }
                if (Xml.this._xmlOptionCaseFolding) {
                    eName = eName.toUpperCase(Locale.ENGLISH);
                }
                ((Value)elementArray).put(this._env.createString("tag"), this._env.createString(eName));
                ((Value)elementArray).put(this._env.createString("type"), this._env.createString("close"));
                ((Value)elementArray).put(this._env.createString("level"), LongValue.create(this._level));
                this._valueArray.put(LongValue.create(this._valueArrayIndex), elementArray);
                this.addToIndexArrayHashMap(eName);
                ++this._valueArrayIndex;
            }
            this._isComplete = false;
            this._isOutside = true;
        }

        private void addToIndexArrayHashMap(String eName) {
            StringValue key = this._env.createString(eName);
            ArrayValueImpl indexArray = this._indexArrayHashMap.get(key);
            if (indexArray == null) {
                indexArray = new ArrayValueImpl();
                this._indexArrayKeys.add(key);
            }
            indexArray.put(LongValue.create(this._valueArrayIndex));
            this._indexArrayHashMap.put(key, indexArray);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this._isOutside) {
                StringValue s = this._env.createString(ch, start, length);
                ArrayValueImpl elementArray = new ArrayValueImpl();
                ((Value)elementArray).put(this._env.createString("tag"), this._env.createString(this._paramHashMap.get(this._level - 1)));
                ((Value)elementArray).put(this._env.createString("value"), s);
                ((Value)elementArray).put(this._env.createString("type"), this._env.createString("cdata"));
                ((Value)elementArray).put(this._env.createString("level"), LongValue.create(this._level - 1));
                this._valueArray.put(LongValue.create(this._valueArrayIndex), elementArray);
                StringValue key = this._env.createString(this._paramHashMap.get(this._level - 1));
                Value indexArray = this._indexArray.get(key);
                indexArray.put(LongValue.create(this._valueArrayIndex));
                ++this._valueArrayIndex;
            } else {
                StringValue key;
                Value elementArray = this._valueArray.get(this._valueArrayIndex - 1);
                Value value = elementArray.get(key = this._env.createString("value"));
                if (value.isString()) {
                    StringValue sb = this._env.createStringBuilder();
                    sb.append(value);
                    sb.append(ch, start, length);
                    elementArray.put(key, sb);
                } else {
                    elementArray.put(key, this._env.createString(ch, start, length));
                }
            }
        }
    }
}

