/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zip;

import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.zip.QuercusZipEntry;
import java.io.IOException;
import java.util.zip.ZipEntry;

public class ZipDirectory {
    private BinaryInput _in;
    private byte[] _tmpBuf;
    private ZipEntry _currentEntry;
    private boolean _eof;
    private boolean _ddescriptor;

    public ZipDirectory(BinaryInput in) {
        this._in = in;
        this._tmpBuf = new byte[32];
        this._eof = false;
    }

    public QuercusZipEntry zip_read() throws IOException {
        this.closeEntry();
        long position = this._in.getPosition();
        ZipEntry entry = this.readEntry();
        if (entry == null) {
            return null;
        }
        return new QuercusZipEntry(entry, this._in.openCopy(), position);
    }

    protected ZipEntry readEntry() throws IOException {
        String name;
        if (this._eof || this._currentEntry != null) {
            return null;
        }
        int sublen = this._in.read(this._tmpBuf, 0, 30);
        if (sublen < 30) {
            this._eof = true;
            return null;
        }
        if (((this._tmpBuf[3] & 0xFF) << 24 | (this._tmpBuf[2] & 0xFF) << 16 | (this._tmpBuf[1] & 0xFF) << 8 | this._tmpBuf[0] & 0xFF) != 67324752) {
            this._eof = true;
            return null;
        }
        this._ddescriptor = (this._tmpBuf[6] & 4) == 4;
        int compressionMethod = this._tmpBuf[8] & 0xFF | (this._tmpBuf[9] & 0xFF) << 8;
        long crc32 = this._tmpBuf[14] & 0xFF;
        crc32 |= (long)((this._tmpBuf[15] & 0xFF) << 8);
        crc32 |= (long)((this._tmpBuf[16] & 0xFF) << 16);
        crc32 |= ((long)this._tmpBuf[17] & 0xFFL) << 24;
        long compressedSize = this._tmpBuf[18] & 0xFF;
        compressedSize |= (long)((this._tmpBuf[19] & 0xFF) << 8);
        compressedSize |= (long)((this._tmpBuf[20] & 0xFF) << 16);
        compressedSize |= ((long)this._tmpBuf[21] & 0xFFL) << 24;
        long uncompressedSize = this._tmpBuf[22] & 0xFF;
        uncompressedSize |= (long)((this._tmpBuf[23] & 0xFF) << 8);
        uncompressedSize |= (long)((this._tmpBuf[24] & 0xFF) << 16);
        uncompressedSize |= ((long)this._tmpBuf[25] & 0xFFL) << 24;
        int filenameLength = this._tmpBuf[26] & 0xFF;
        int extraLength = this._tmpBuf[28] & 0xFF;
        extraLength |= (this._tmpBuf[29] & 0xFF) << 8;
        if ((filenameLength |= (this._tmpBuf[27] & 0xFF) << 8) <= this._tmpBuf.length) {
            sublen = this._in.read(this._tmpBuf, 0, filenameLength);
            if (sublen < filenameLength) {
                return null;
            }
            name = new String(this._tmpBuf, 0, sublen);
        } else {
            byte[] buffer = new byte[filenameLength];
            sublen = this._in.read(buffer, 0, buffer.length);
            if (sublen < filenameLength) {
                return null;
            }
            name = new String(buffer, 0, sublen);
        }
        if (extraLength > 0) {
            this.skip(extraLength);
        }
        ZipEntry entry = new ZipEntry(name);
        entry.setMethod(compressionMethod);
        entry.setCrc(crc32);
        entry.setCompressedSize(compressedSize);
        entry.setSize(uncompressedSize);
        this._currentEntry = entry;
        return entry;
    }

    private void skip(long len) throws IOException {
        while (len-- > 0L && this._in.read() != -1) {
        }
    }

    protected void closeEntry() throws IOException {
        if (this._currentEntry == null) {
            return;
        }
        long length = this._currentEntry.getCompressedSize();
        if (this._ddescriptor) {
            length += 12L;
        }
        this.skip(length);
        this._currentEntry = null;
    }

    public boolean zip_close() {
        this._in.close();
        return true;
    }

    public String toString() {
        return "ZipDirectory[]";
    }
}

