/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaAdapter;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class ArrayValueMarshal
extends Marshal {
    public static final Marshal MARSHAL = new ArrayValueMarshal();

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.eval(env).toArrayValue(env);
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toArrayValue(env);
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        if (value instanceof ArrayValue) {
            return (ArrayValue)value;
        }
        if (value instanceof Value) {
            return ((Value)value).toArrayValue(env);
        }
        return NullValue.NULL;
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue.isArray()) {
            if (argValue instanceof JavaAdapter) {
                return 100;
            }
            return 0;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return ArrayValue.class;
    }
}

