/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.BigDecimalValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;
import java.math.BigDecimal;

public class BigDecimalMarshal
extends Marshal {
    public static final Marshal MARSHAL = new BigDecimalMarshal();

    @Override
    public Object marshal(Env env, Expr expr, Class argClass) {
        return expr.eval(env).toBigDecimal();
    }

    @Override
    public Object marshal(Env env, Value value, Class argClass) {
        return value.toBigDecimal();
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        return env.wrapJava((BigDecimal)value);
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof BigDecimalValue) {
            return 0;
        }
        if (argValue instanceof DoubleValue) {
            return 100;
        }
        if (argValue instanceof LongValue) {
            return 100;
        }
        if (argValue.isDoubleConvertible()) {
            return 100;
        }
        if (argValue.isLongConvertible()) {
            return 100;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return BigDecimal.class;
    }
}

