/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.lib.regexp.Ereg;
import com.caucho.quercus.lib.regexp.RegexpModule;
import com.caucho.quercus.marshal.StringMarshal;

public class EregMarshal
extends StringMarshal {
    public static final EregMarshal MARSHAL = new EregMarshal();

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return RegexpModule.createEreg(env, expr.eval(env));
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return RegexpModule.createEreg(env, value);
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue.isString()) {
            return 0;
        }
        return 0x3FFFFFF;
    }

    @Override
    public Class getExpectedClass() {
        return Ereg.class;
    }
}

