/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class LongValueMarshal
extends Marshal {
    public static final Marshal MARSHAL = new LongValueMarshal();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.eval(env).toLongValue();
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toLongValue();
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        if (value instanceof LongValue) {
            return (LongValue)value;
        }
        if (value instanceof Value) {
            return ((Value)value).toLongValue();
        }
        return null;
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof LongValue) {
            return 0;
        }
        if (argValue.isLongConvertible()) {
            return 301;
        }
        if (argValue.isDoubleConvertible()) {
            return 305;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return LongValue.class;
    }
}

