/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.profile;

import com.caucho.quercus.profile.ProfileItem;
import com.caucho.quercus.profile.ProfileMethod;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;

public class ProfileReport {
    private long _id;
    private String _url;
    private long _timestamp;
    private ArrayList<ProfileItem> _itemList = new ArrayList();
    private HashMap<String, ProfileMethod> _methodMap = new HashMap();
    private long _totalMicros;

    public ProfileReport(long id, String url, long timestamp) {
        this._id = id;
        this._url = url;
        this._timestamp = timestamp;
    }

    public long getId() {
        return this._id;
    }

    public String getUrl() {
        return this._url;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public long getTotalMicros() {
        return this._totalMicros;
    }

    public ArrayList<ProfileItem> getItemList() {
        return this._itemList;
    }

    public ArrayList<ProfileMethod> getMethods() {
        ArrayList<ProfileMethod> methodList = new ArrayList<ProfileMethod>(this._methodMap.values());
        return methodList;
    }

    public ArrayList<ProfileMethod> getMethodsBySelfMicros() {
        ArrayList<ProfileMethod> methodList = new ArrayList<ProfileMethod>(this._methodMap.values());
        Collections.sort(methodList, new SelfMicrosComparator());
        return methodList;
    }

    public void addItem(String name, String parent, long count, long micros) {
        ProfileItem item = new ProfileItem(name, parent, count, micros);
        this._itemList.add(item);
        ProfileMethod method = this.getMethod(name);
        method.addParent(item);
        if ("__top__".equals(name)) {
            this._totalMicros = item.getMicros();
        } else {
            ProfileMethod parentMethod = this.getMethod(parent);
            parentMethod.addChild(item);
        }
    }

    public ProfileMethod findMethodByIndex(int id) {
        for (ProfileMethod method : this._methodMap.values()) {
            if (id != method.getId()) continue;
            return method;
        }
        return null;
    }

    public ProfileMethod findMethodByName(String name) {
        return this._methodMap.get(name);
    }

    protected ProfileMethod getMethod(String name) {
        ProfileMethod method = this._methodMap.get(name);
        if (method == null) {
            method = new ProfileMethod(this._methodMap.size(), name);
            this._methodMap.put(name, method);
        }
        return method;
    }

    public void printHotSpotReport(OutputStream os) throws IOException {
        WriteStream out = Vfs.openWrite(os);
        ArrayList<ProfileMethod> methodList = new ArrayList<ProfileMethod>(this._methodMap.values());
        Collections.sort(methodList, new SelfMicrosComparator());
        double totalMicros = 0.0;
        int maxNameLength = 0;
        for (ProfileMethod method : methodList) {
            int len = method.getName().length();
            if (maxNameLength < len) {
                maxNameLength = len;
            }
            totalMicros += (double)method.getSelfMicros();
        }
        out.println();
        out.println("Hot Spot Profile: " + this._url + " at " + new Date(this._timestamp));
        out.println();
        out.println(" self(us)  total(us)  count   %time     %sum   name");
        out.println("----------------------------------------------------");
        double sumMicros = 0.0;
        for (ProfileMethod method : methodList) {
            String name = method.getName();
            long selfMicros = method.getSelfMicros();
            out.print(String.format("%7dus", selfMicros));
            out.print(String.format(" %8dus", method.getTotalMicros()));
            out.print(String.format(" %6d", method.getCount()));
            out.print(String.format(" %6.2f%%", 100.0 * (double)selfMicros / totalMicros));
            out.print(String.format("  %6.2f%%", 100.0 * (sumMicros += (double)selfMicros) / totalMicros));
            out.print("   " + name);
            out.println();
        }
        out.println();
        out.close();
    }

    public void printHierarchyReport(OutputStream os) throws IOException {
        WriteStream out = Vfs.openWrite(os);
        ArrayList<ProfileMethod> methodList = new ArrayList<ProfileMethod>(this._methodMap.values());
        Collections.sort(methodList, new TotalMicrosComparator());
        double totalMicros = methodList.get(0).getTotalMicros();
        boolean maxNameLength = false;
        out.println();
        out.println("Hierarchy: " + this._url + " at " + new Date(this._timestamp));
        out.println();
        out.println(" total(us)  self(us)  count   %time     %sum   name");
        out.println("----------------------------------------------------");
        double sumMicros = 0.0;
        for (ProfileMethod method : methodList) {
            String name = method.getName();
            long ownTotalMicros = method.getTotalMicros();
            long selfMicros = method.getSelfMicros();
            sumMicros += (double)selfMicros;
            out.println();
            ArrayList<ProfileItem> parentList = new ArrayList<ProfileItem>(method.getParentItems());
            Collections.sort(parentList, new ItemMicrosComparator());
            for (ProfileItem item : parentList) {
                out.print("        ");
                out.print(String.format(" %7dus", item.getMicros()));
                out.print(String.format(" %6d", item.getCount()));
                out.print(String.format("     %-19s", item.getParent()));
                out.print(String.format("%6.2f%%", 100.0 * (double)item.getMicros() / (double)ownTotalMicros));
                out.println();
            }
            out.print(String.format(" %6.2f%%", 100.0 * (double)ownTotalMicros / totalMicros));
            out.print(String.format(" %7dus", method.getTotalMicros()));
            out.print(String.format(" %6d", method.getCount()));
            out.print(String.format("  %-22s", name));
            out.print(String.format("%6.2f%%", 100.0 * (double)selfMicros / (double)ownTotalMicros));
            out.print(String.format(" %7dus", method.getSelfMicros()));
            out.println();
            ArrayList<ProfileItem> childList = new ArrayList<ProfileItem>(method.getChildItems());
            Collections.sort(childList, new ItemMicrosComparator());
            for (ProfileItem item : childList) {
                out.print("        ");
                out.print(String.format(" %7dus", item.getMicros()));
                out.print(String.format(" %6d", item.getCount()));
                out.print(String.format("     %-19s", item.getName()));
                out.print(String.format("%6.2f%%", 100.0 * (double)item.getMicros() / (double)ownTotalMicros));
                out.println();
            }
        }
        out.println();
        out.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static class ItemMicrosComparator
    implements Comparator<ProfileItem> {
        ItemMicrosComparator() {
        }

        @Override
        public int compare(ProfileItem a, ProfileItem b) {
            long delta = b.getMicros() - a.getMicros();
            if (delta == 0L) {
                return 0;
            }
            if (delta < 0L) {
                return -1;
            }
            return 1;
        }
    }

    static class TotalMicrosComparator
    implements Comparator<ProfileMethod> {
        TotalMicrosComparator() {
        }

        @Override
        public int compare(ProfileMethod a, ProfileMethod b) {
            long delta = b.getTotalMicros() - a.getTotalMicros();
            if (delta == 0L) {
                return 0;
            }
            if (delta < 0L) {
                return -1;
            }
            return 1;
        }
    }

    static class SelfMicrosComparator
    implements Comparator<ProfileMethod> {
        SelfMicrosComparator() {
        }

        @Override
        public int compare(ProfileMethod a, ProfileMethod b) {
            long delta = b.getSelfMicros() - a.getSelfMicros();
            if (delta == 0L) {
                return 0;
            }
            if (delta < 0L) {
                return -1;
            }
            return 1;
        }
    }
}

