/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet.api;

import com.caucho.quercus.servlet.api.QuercusCookie;
import com.caucho.quercus.servlet.api.QuercusCookieImpl;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequest;
import com.caucho.quercus.servlet.api.QuercusHttpSession;
import com.caucho.quercus.servlet.api.QuercusHttpSessionImpl;
import com.caucho.quercus.servlet.api.QuercusRequestDispatcher;
import com.caucho.quercus.servlet.api.QuercusRequestDispatcherImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class QuercusHttpServletRequestImpl
implements QuercusHttpServletRequest {
    private final HttpServletRequest _request;

    public QuercusHttpServletRequestImpl(HttpServletRequest request) {
        this._request = request;
    }

    @Override
    public String getMethod() {
        return this._request.getMethod();
    }

    @Override
    public String getHeader(String name) {
        return this._request.getHeader(name);
    }

    @Override
    public Enumeration getHeaderNames() {
        return this._request.getHeaderNames();
    }

    @Override
    public String getParameter(String name) {
        return this._request.getParameter(name);
    }

    @Override
    public String[] getParameterValues(String name) {
        return this._request.getParameterValues(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this._request.getParameterMap();
    }

    @Override
    public String getContentType() {
        return this._request.getContentType();
    }

    @Override
    public String getCharacterEncoding() {
        return this._request.getCharacterEncoding();
    }

    @Override
    public String getRequestURI() {
        return this._request.getRequestURI();
    }

    @Override
    public String getQueryString() {
        return this._request.getQueryString();
    }

    @Override
    public QuercusCookie[] getCookies() {
        Cookie[] cookies = this._request.getCookies();
        if (cookies == null) {
            return new QuercusCookie[0];
        }
        QuercusCookie[] qCookies = new QuercusCookie[cookies.length];
        for (int i = 0; i < cookies.length; ++i) {
            qCookies[i] = new QuercusCookieImpl(cookies[i]);
        }
        return qCookies;
    }

    @Override
    public String getContextPath() {
        return this._request.getContextPath();
    }

    @Override
    public String getServletPath() {
        return this._request.getServletPath();
    }

    @Override
    public String getPathInfo() {
        return this._request.getPathInfo();
    }

    @Override
    public String getRealPath(String path) {
        return this._request.getRealPath(path);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this._request.getInputStream();
    }

    @Override
    public QuercusHttpSession getSession(boolean isCreate) {
        HttpSession session = this._request.getSession(isCreate);
        if (session == null) {
            return null;
        }
        return new QuercusHttpSessionImpl(session);
    }

    @Override
    public String getLocalAddr() {
        return this._request.getLocalAddr();
    }

    @Override
    public String getServerName() {
        return this._request.getServerName();
    }

    @Override
    public int getServerPort() {
        return this._request.getServerPort();
    }

    @Override
    public String getRemoteHost() {
        return this._request.getRemoteHost();
    }

    @Override
    public String getRemoteAddr() {
        return this._request.getRemoteAddr();
    }

    @Override
    public int getRemotePort() {
        return this._request.getRemotePort();
    }

    @Override
    public String getRemoteUser() {
        return this._request.getRemoteUser();
    }

    @Override
    public boolean isSecure() {
        return this._request.isSecure();
    }

    @Override
    public String getProtocol() {
        return this._request.getProtocol();
    }

    @Override
    public Object getAttribute(String name) {
        return this._request.getAttribute(name);
    }

    @Override
    public String getIncludeRequestUri() {
        return (String)this._request.getAttribute("javax.servlet.include.request_uri");
    }

    @Override
    public String getForwardRequestUri() {
        return (String)this._request.getAttribute("javax.servlet.forward.request_uri");
    }

    @Override
    public String getIncludeContextPath() {
        return (String)this._request.getAttribute("javax.servlet.include.context_path");
    }

    @Override
    public String getIncludeServletPath() {
        return (String)this._request.getAttribute("javax.servlet.include.servlet_path");
    }

    @Override
    public String getIncludePathInfo() {
        return (String)this._request.getAttribute("javax.servlet.include.path_info");
    }

    @Override
    public String getIncludeQueryString() {
        return (String)this._request.getAttribute("javax.servlet.include.query_string");
    }

    @Override
    public QuercusRequestDispatcher getRequestDispatcher(String url) {
        RequestDispatcher dispatcher = this._request.getRequestDispatcher(url);
        return new QuercusRequestDispatcherImpl(dispatcher);
    }

    @Override
    public <T> T toRequest(Class<T> cls) {
        return (T)this._request;
    }
}

