/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.statement;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.statement.Statement;
import java.util.ArrayList;

public class BlockStatement
extends Statement {
    protected Statement[] _statements;

    public BlockStatement(Location location, Statement[] statements) {
        super(location);
        for (Statement stmt : this._statements = statements) {
            stmt.setParent(this);
        }
    }

    public BlockStatement(Location location, ArrayList<Statement> statementList) {
        super(location);
        this._statements = new Statement[statementList.size()];
        statementList.toArray(this._statements);
        for (Statement stmt : this._statements) {
            stmt.setParent(this);
        }
    }

    public BlockStatement append(ArrayList<Statement> statementList) {
        Statement[] statements = new Statement[this._statements.length + statementList.size()];
        System.arraycopy(this._statements, 0, statements, 0, this._statements.length);
        for (int i = 0; i < statementList.size(); ++i) {
            statements[i + this._statements.length] = statementList.get(i);
        }
        return new BlockStatement(this.getLocation(), statements);
    }

    public Statement[] getStatements() {
        return this._statements;
    }

    @Override
    public int fallThrough() {
        for (int i = 0; i < this.getStatements().length; ++i) {
            Statement stmt = this.getStatements()[i];
            int fallThrough = stmt.fallThrough();
            if (fallThrough == 0) continue;
            return fallThrough;
        }
        return 0;
    }

    @Override
    public Value execute(Env env) {
        for (int i = 0; i < this._statements.length; ++i) {
            Statement statement = this._statements[i];
            Value value = statement.execute(env);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

