/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.statement;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Closure;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.VarExpr;
import com.caucho.quercus.statement.Statement;

public class ClosureStaticStatement
extends Statement {
    protected VarExpr _var;
    protected Expr _initValue;

    public ClosureStaticStatement(Location location, VarExpr var, Expr initValue) {
        super(location);
        this._var = var;
        this._initValue = initValue;
    }

    @Override
    public Value execute(Env env) {
        Closure closure = env.getClosure();
        try {
            Var var = closure.getStaticVar(this._var.getName());
            env.setRef(this._var.getName(), var);
            if (!var.isset() && this._initValue != null) {
                var.set(this._initValue.eval(env));
            }
        }
        catch (RuntimeException e) {
            this.rethrow(e, RuntimeException.class);
        }
        return null;
    }
}

