/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.statement;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.BreakValue;
import com.caucho.quercus.env.ContinueValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.statement.Statement;
import java.util.Iterator;
import java.util.Map;

public class ForeachStatement
extends Statement {
    protected final Expr _objExpr;
    protected final AbstractVarExpr _key;
    protected final AbstractVarExpr _value;
    protected final boolean _isRef;
    protected final Statement _block;
    protected final String _label;

    public ForeachStatement(Location location, Expr objExpr, AbstractVarExpr key, AbstractVarExpr value, boolean isRef, Statement block, String label) {
        super(location);
        this._objExpr = objExpr;
        this._key = key;
        this._value = value;
        this._isRef = isRef;
        this._block = block;
        this._label = label;
        block.setParent(this);
    }

    @Override
    public boolean isLoop() {
        return true;
    }

    @Override
    public Value execute(Env env) {
        Value origObj = this._objExpr.eval(env);
        Value obj = origObj.copy();
        if (this._key == null && !this._isRef) {
            Iterator<Value> iter = obj.getValueIterator(env);
            while (iter.hasNext()) {
                int target;
                Value value = iter.next();
                value = value.copy();
                this._value.evalAssignValue(env, value);
                Value result = this._block.execute(env);
                if (result == null) continue;
                if (result instanceof ContinueValue) {
                    ContinueValue conValue = (ContinueValue)result;
                    target = conValue.getTarget();
                    if (target <= 1) continue;
                    return new ContinueValue(target - 1);
                }
                if (result instanceof BreakValue) {
                    BreakValue breakValue = (BreakValue)result;
                    target = breakValue.getTarget();
                    if (target <= 1) break;
                    return new BreakValue(target - 1);
                }
                return result;
            }
            return null;
        }
        if (this._isRef) {
            Iterator<Value> iter = obj.getKeyIterator(env);
            while (iter.hasNext()) {
                int target;
                Value key = iter.next();
                if (this._key != null) {
                    this._key.evalAssignValue(env, key);
                }
                Var value = origObj.getVar(key);
                this._value.evalAssignRef(env, value);
                Value result = this._block.execute(env);
                if (result == null) continue;
                if (result instanceof ContinueValue) {
                    ContinueValue conValue = (ContinueValue)result;
                    target = conValue.getTarget();
                    if (target <= 1) continue;
                    return new ContinueValue(target - 1);
                }
                if (result instanceof BreakValue) {
                    BreakValue breakValue = (BreakValue)result;
                    target = breakValue.getTarget();
                    if (target > 1) {
                        return new BreakValue(target - 1);
                    }
                    break;
                }
                return result;
            }
        } else {
            Iterator<Map.Entry<Value, Value>> iter = obj.getIterator(env);
            while (iter.hasNext()) {
                int target;
                Map.Entry<Value, Value> entry = iter.next();
                Value key = entry.getKey();
                Value value = entry.getValue();
                value = value.copy();
                this._key.evalAssignValue(env, key);
                this._value.evalAssignValue(env, value);
                Value result = this._block.execute(env);
                if (result == null) continue;
                if (result instanceof ContinueValue) {
                    ContinueValue conValue = (ContinueValue)result;
                    target = conValue.getTarget();
                    if (target <= 1) continue;
                    return new ContinueValue(target - 1);
                }
                if (result instanceof BreakValue) {
                    BreakValue breakValue = (BreakValue)result;
                    target = breakValue.getTarget();
                    if (target > 1) {
                        return new BreakValue(target - 1);
                    }
                    break;
                }
                return result;
            }
        }
        return null;
    }
}

