/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.statement;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.statement.Statement;
import com.caucho.util.L10N;

public class FunctionDefStatement
extends Statement {
    private static final L10N L = new L10N(FunctionDefStatement.class);
    protected Function _fun;

    public FunctionDefStatement(Location location, Function fun) {
        super(location);
        this._fun = fun;
    }

    @Override
    public Value execute(Env env) {
        try {
            String name = this._fun.getName();
            if (env.findFunction(env.createString(name)) == null) {
                env.addFunction(name, (AbstractFunction)this._fun);
            } else {
                env.error(L.l("function {0}() is already defined.", (Object)name), this.getLocation());
            }
        }
        catch (RuntimeException e) {
            this.rethrow(e, RuntimeException.class);
        }
        return null;
    }
}

