/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.inject.Module;
import com.caucho.transaction.ManagedResource;
import com.caucho.transaction.ManagedXAResource;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.UserTransactionSuspendState;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class UserTransactionImpl
implements UserTransaction {
    private static final Logger log = Logger.getLogger(UserTransactionImpl.class.getName());
    private static final L10N L = new L10N(UserTransactionImpl.class);
    private TransactionManagerImpl _transactionManager;
    private ArrayList<ManagedResource> _resources = new ArrayList();
    private ArrayList<ManagedXAResource> _xaResources = new ArrayList();
    private boolean _isInContext;
    private boolean _isTransactionActive;

    public UserTransactionImpl(TransactionManagerImpl tm) {
        this._transactionManager = tm;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this._transactionManager.setTransactionTimeout(seconds);
    }

    public int getStatus() throws SystemException {
        return this._transactionManager.getStatus();
    }

    public boolean isInContext() {
        return this._isInContext;
    }

    public void setInContext(boolean isInContext) {
        this._isInContext = isInContext;
    }

    public boolean isActive() {
        return this._isTransactionActive;
    }

    public void enlistResource(ManagedResource resource) throws SystemException, RollbackException {
        ManagedXAResource xaResource;
        if (resource == null) {
            throw new NullPointerException();
        }
        if (this._resources.contains(resource)) {
            return;
        }
        TransactionImpl xa = this._transactionManager.getTransaction();
        if (xa != null && xa.isActive() && (xaResource = resource.getXAResource()) != null) {
            this.enlistXaResource(xa, xaResource);
        }
        this._resources.add(resource);
    }

    private void enlistXaResource(Transaction xa, ManagedXAResource xaResource) throws SystemException, RollbackException {
        TransactionImpl xaImpl;
        if (xaResource == null) {
            return;
        }
        if (!xaResource.supportsTransaction()) {
            return;
        }
        if (this._xaResources.contains(xaResource)) {
            return;
        }
        xaResource.setTransaction(this);
        if (xa instanceof TransactionImpl && (xaImpl = (TransactionImpl)xa).allowLocalTransactionOptimization()) {
            xaResource.enableLocalTransactionOptimization(true);
        }
        if (xaResource.getXid() == null) {
            xa.enlistResource((XAResource)xaResource);
        }
        this._xaResources.add(xaResource);
    }

    public void delistResource(ManagedResource resource) {
        this._resources.remove(resource);
    }

    @Module
    public ArrayList<ManagedXAResource> getXaResources() {
        return this._xaResources;
    }

    public Xid getXid() throws SystemException, RollbackException {
        TransactionImpl xa = this._transactionManager.getTransaction();
        if (xa != null) {
            return xa.getXid();
        }
        return null;
    }

    public int getEnlistedResourceCount() throws SystemException, RollbackException {
        TransactionImpl xa = this._transactionManager.getTransaction();
        if (xa != null) {
            return xa.getEnlistedResourceCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws NotSupportedException, SystemException {
        int i;
        if (this._isTransactionActive) {
            throw new NotSupportedException(L.l("UserTransaction.begin() is not allowed because an active transaction already exists.  This may be caused by either a missing commit/rollback or a nested begin().  Nested transactions are not supported."));
        }
        this._transactionManager.begin();
        this._isTransactionActive = true;
        boolean isOkay = false;
        try {
            TransactionImpl xa = this._transactionManager.getTransaction();
            xa.setUserTransaction(this);
            this._xaResources.clear();
            int length = this._resources.size();
            for (i = 0; i < length; ++i) {
                ManagedXAResource xaResource;
                ManagedResource resource = this._resources.get(i);
                for (int j = this._xaResources.size() - 1; j >= 0 && !(xaResource = this._xaResources.get(j)).share(resource); --j) {
                }
                ManagedXAResource xaResource2 = resource.getXAResource();
                if (xaResource2 == null || this._xaResources.contains(xaResource2)) continue;
                this._xaResources.add(xaResource2);
            }
            for (i = 0; i < this._xaResources.size(); ++i) {
                ManagedXAResource xaResource = this._xaResources.get(i);
                xaResource.enableLocalTransactionOptimization(this._xaResources.size() == 1);
                try {
                    xa.enlistResource(xaResource);
                    continue;
                }
                catch (Exception e) {
                    String message = L.l("Failed to begin UserTransaction due to: {0}", (Object)e);
                    log.log(Level.SEVERE, message, e);
                    throw new SystemException(message);
                }
            }
            isOkay = true;
        }
        finally {
            if (!isOkay) {
                IllegalStateException e1 = new IllegalStateException(L.l("Rolling back transaction from failed begin."));
                e1.fillInStackTrace();
                log.log(Level.WARNING, e1.toString(), e1);
                this._isTransactionActive = false;
                ArrayList<ManagedXAResource> xaResources = new ArrayList<ManagedXAResource>(this._xaResources);
                this._xaResources.clear();
                this._resources.clear();
                for (i = 0; i < xaResources.size(); ++i) {
                    try {
                        ManagedXAResource item = xaResources.get(i);
                        item.abortConnection();
                        item.destroy();
                        continue;
                    }
                    catch (Throwable e) {
                        log.log(Level.FINE, e.toString(), e);
                    }
                }
                this._transactionManager.rollback();
            }
        }
    }

    public UserTransactionSuspendState userSuspend() {
        if (!this._isTransactionActive) {
            throw new IllegalStateException(L.l("UserTransaction.suspend may only be called in a transaction, but no transaction is active."));
        }
        this._isTransactionActive = false;
        UserTransactionSuspendState state = new UserTransactionSuspendState(this._xaResources);
        this._xaResources.clear();
        return state;
    }

    public void userResume(UserTransactionSuspendState state) {
        if (this._isTransactionActive) {
            throw new IllegalStateException(L.l("UserTransaction.resume may only be called outside of a transaction, because the resumed transaction must not conflict with an active transaction."));
        }
        this._isTransactionActive = true;
        this._xaResources.addAll(state.getXAResources());
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this._transactionManager.setRollbackOnly();
    }

    public void setRollbackOnly(Exception e) throws IllegalStateException {
        this._transactionManager.setRollbackOnly(e);
    }

    public void commit() throws IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        try {
            if (!this._isTransactionActive) {
                throw new IllegalStateException("UserTransaction.commit() requires an active transaction.  Either the UserTransaction.begin() is missing or the transaction has already been committed or rolled back.");
            }
            this._transactionManager.commit();
        }
        finally {
            this._xaResources.clear();
            this._isTransactionActive = false;
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this._transactionManager.rollback();
        }
        finally {
            this._isTransactionActive = false;
            this._xaResources.clear();
        }
    }

    public void abortTransaction() throws IllegalStateException {
        IllegalStateException exn = null;
        this._isInContext = false;
        boolean isTransactionActive = this._isTransactionActive;
        this._isTransactionActive = false;
        if (!isTransactionActive && this._xaResources.size() > 0) {
            IllegalStateException e = new IllegalStateException("Internal error: user transaction pool broken because poolItems exist, but no transaction is active.");
            log.log(Level.WARNING, e.toString(), e);
        }
        this._xaResources.clear();
        if (isTransactionActive) {
            try {
                exn = new IllegalStateException(L.l("Transactions must have a commit() or rollback() in a finally block."));
                log.warning("Rolling back unclosed transaction.  All transactions must have a commit() or rollback() in a finally block.");
                this._transactionManager.addUnclosedTransaction("Rolling back unclosed transaction.");
                this._transactionManager.rollback();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString());
            }
        }
        this._xaResources.clear();
        exn = this.clearDanglingResources(exn);
        try {
            this._transactionManager.setTransactionTimeout(0);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (exn != null) {
            throw exn;
        }
    }

    private IllegalStateException clearDanglingResources(IllegalStateException exn) {
        if (this._resources.size() == 0) {
            return exn;
        }
        ArrayList<ManagedResource> resourceList = new ArrayList<ManagedResource>(this._resources);
        this._resources.clear();
        boolean hasWarning = false;
        for (ManagedResource resource : resourceList) {
            if (!resource.isCloseDanglingConnections()) continue;
            if (!hasWarning) {
                hasWarning = true;
                log.warning("Closing dangling resources.  Applications must close all resources in a finally block.");
            }
            try {
                IllegalStateException stackTrace = resource.getAllocationStackTrace();
                if (stackTrace != null) {
                    log.log(Level.WARNING, stackTrace.getMessage(), stackTrace);
                } else {
                    resource.setSaveAllocationStackTrace(true);
                }
                String msg = L.l("Resource {0} was not closed. Applications must close all resources in a finally block.", resource.getUserConnection());
                if (exn == null) {
                    exn = new IllegalStateException(msg);
                }
                this._transactionManager.addUnclosedResource(msg);
                resource.abortConnection();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return exn;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

