/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.LruCache;

public class TimedCache<K, V> {
    private LruCache<K, Entry<V>> _cache;
    private long _expireInterval;

    public TimedCache(int capacity, long expireInterval) {
        this._cache = new LruCache(capacity);
        this._expireInterval = expireInterval;
    }

    public V put(K key, V value) {
        Entry<V> oldValue = this._cache.put(key, new Entry<V>(this._expireInterval, value));
        if (oldValue != null) {
            return oldValue.getValue();
        }
        return null;
    }

    public V get(K key) {
        Entry<V> entry = this._cache.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.isValid()) {
            return entry.getValue();
        }
        this._cache.remove(key);
        return null;
    }

    static class Entry<V>
    implements CacheListener {
        private long _expireInterval;
        private long _checkTime;
        private V _value;

        Entry(long expireInterval, V value) {
            this._expireInterval = expireInterval;
            this._value = value;
            this._checkTime = CurrentTime.getCurrentTime();
        }

        boolean isValid() {
            return CurrentTime.getCurrentTime() < this._checkTime + this._expireInterval;
        }

        V getValue() {
            return this._value;
        }

        @Override
        public void removeEvent() {
            if (this._value instanceof CacheListener) {
                ((CacheListener)this._value).removeEvent();
            }
        }
    }
}

