/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.util.IoUtil;
import com.caucho.vfs.GoogleInode;
import com.caucho.vfs.GooglePath;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GoogleInodeService {
    private static final Logger log = Logger.getLogger(GoogleInodeService.class.getName());
    private final MemcacheService _memcacheService;

    public GoogleInodeService(String namespace) {
        this(MemcacheServiceFactory.getMemcacheService((String)namespace));
    }

    public GoogleInodeService(MemcacheService memcacheService) {
        this._memcacheService = memcacheService;
    }

    public GoogleInode getGoogleInode(GooglePath path) {
        HashMap<String, GoogleInode> dirMap = this.readDirMap(path.getParent());
        GoogleInode gsInode = null;
        String name = path.getTail();
        if (dirMap != null) {
            gsInode = dirMap.get(name);
        }
        if (gsInode == null) {
            gsInode = new GoogleInode(name, GoogleInode.FileType.NONE, -1L, -1L);
        }
        return gsInode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, GoogleInode> readDirMap(GooglePath path) {
        String fullPath = path.getFullPath();
        HashMap dirMap = (HashMap)this._memcacheService.get((Object)fullPath);
        if (dirMap != null) {
            return dirMap;
        }
        ReadStream is = null;
        try {
            is = path.openRead();
            Hessian2Input hIn = new Hessian2Input((InputStream)is);
            dirMap = (HashMap)hIn.readObject();
            hIn.close();
            boolean result = this._memcacheService.put((Object)fullPath, (Object)dirMap, null, MemcacheService.SetPolicy.ADD_ONLY_IF_NOT_PRESENT);
            HashMap hashMap = dirMap;
            return hashMap;
        }
        catch (FileNotFoundException e) {
            log.log(Level.FINER, e.toString(), e);
            HashMap<String, GoogleInode> hashMap = null;
            return hashMap;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            HashMap<String, GoogleInode> hashMap = null;
            return hashMap;
        }
        finally {
            IoUtil.close(is);
        }
    }

    public boolean writeDirMap(GooglePath path, HashMap<String, GoogleInode> dirMap) {
        String fullPath = path.getFullPath();
        WriteStream out = null;
        try {
            out = path.openWrite();
            Hessian2Output hOut = new Hessian2Output((OutputStream)out);
            hOut.writeObject(dirMap);
            hOut.close();
            this._memcacheService.put((Object)fullPath, dirMap);
            out.close();
            return true;
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            IoUtil.close(out);
            return false;
        }
    }
}

