/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VfsStream
extends StreamImpl {
    private static byte[] UNIX_NEWLINE = new byte[]{10};
    private InputStream _is;
    private OutputStream _os;
    private boolean _flushOnNewline;
    private boolean _closeChildOnClose = true;
    private byte[] _newline = UNIX_NEWLINE;
    private long _position;

    public VfsStream() {
    }

    public VfsStream(InputStream is, OutputStream os) {
        this.init(is, os);
    }

    public VfsStream(InputStream is, OutputStream os, Path path) {
        this.init(is, os);
        this.setPath(path);
    }

    public void init(InputStream is, OutputStream os) {
        this._is = is;
        this._os = os;
        this.setPath(null);
        this._flushOnNewline = false;
        this._closeChildOnClose = true;
        this._position = 0L;
    }

    public void setNewline(byte[] newline) {
        this._newline = newline;
    }

    @Override
    public byte[] getNewline() {
        return this._newline;
    }

    public static ReadWritePair openReadWrite(InputStream is, OutputStream os) {
        VfsStream s = new VfsStream(is, os);
        WriteStream writeStream = new WriteStream(s);
        ReadStream readStream = new ReadStream(s, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public static ReadStream openRead(InputStream is) {
        VfsStream s = new VfsStream(is, null);
        return new ReadStream(s);
    }

    public static ReadStream openRead(InputStream is, WriteStream ws) {
        VfsStream s = new VfsStream(is, null);
        return new ReadStream(s, ws);
    }

    public static WriteStream openWrite(OutputStream os) {
        VfsStream s = new VfsStream(null, os);
        return new WriteStream(s);
    }

    @Override
    public boolean canRead() {
        return this._is != null;
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this._is == null) {
            return -1;
        }
        int len = this._is.read(buf, offset, length);
        if (len > 0) {
            this._position += (long)len;
        }
        return len;
    }

    @Override
    public boolean hasSkip() {
        return true;
    }

    @Override
    public long skip(long n) throws IOException {
        return this._is.skip(n);
    }

    @Override
    public int getAvailable() throws IOException {
        if (this._is == null) {
            return -1;
        }
        return this._is.available();
    }

    @Override
    public long getReadPosition() {
        return this._position;
    }

    @Override
    public boolean canWrite() {
        return this._os != null;
    }

    @Override
    public boolean getFlushOnNewline() {
        return this._flushOnNewline;
    }

    public void setFlushOnNewline(boolean value) {
        this._flushOnNewline = value;
    }

    @Override
    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        OutputStream os = this._os;
        if (os != null) {
            os.write(buf, offset, length);
        }
    }

    @Override
    public void flushToDisk() throws IOException {
        this.flush();
    }

    @Override
    public void flush() throws IOException {
        if (this._os != null) {
            this._os.flush();
        }
    }

    public void setCloseChildOnClose(boolean close) {
        this._closeChildOnClose = close;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._os != null && this._closeChildOnClose) {
                this._os.close();
                this._os = null;
            }
        }
        finally {
            if (this._is != null && this._closeChildOnClose) {
                this._is.close();
                this._is = null;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._is + "," + this._os + "]";
    }
}

