/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempCharBuffer;
import com.caucho.vfs.Vfs;
import com.caucho.xml.stream.NamespaceReaderContext;
import com.caucho.xml.stream.StaxIntern;
import com.caucho.xml.stream.StaxUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStreamReaderImpl
implements XMLStreamReader {
    private static final Logger log = Logger.getLogger(XMLStreamReaderImpl.class.getName());
    private static final L10N L = new L10N(XMLStreamReaderImpl.class);
    private static final boolean[] IS_XML_NAME = new boolean[65536];
    private StaxIntern _intern;
    private ReadStream _is;
    private Reader _reader;
    private int _lastCol = 1;
    private int _col = 1;
    private int _row = 1;
    private int _offset = 1;
    private NamespaceReaderContext _namespaceTracker;
    private String _version = "1.0";
    private String _encoding = "utf-8";
    private String _encodingScheme;
    private String _publicId;
    private String _systemId;
    private boolean _seenDocumentStart = false;
    private int _current;
    private int _state;
    private boolean _isShortTag;
    private boolean _isWhitespace = false;
    private boolean _eofEncountered = false;
    private String _processingInstructionTarget;
    private String _processingInstructionData;
    private RawName _rawTagName = new RawName();
    private QName _name;
    private StaxIntern.Entry[] _attrRawNames = new StaxIntern.Entry[16];
    private QName[] _attrNames = new QName[16];
    private String[] _attrValues = new String[16];
    private int _attrCount;
    private final StringBuilder _sb = new StringBuilder();
    private TempCharBuffer _tempInputBuffer;
    private char[] _inputBuf;
    private int _inputOffset;
    private int _inputLength;
    private TempCharBuffer _tempCharBuffer;
    private char[] _cBuf;
    private int _cBufLength;

    public XMLStreamReaderImpl(InputStream is) throws XMLStreamException {
        this(Vfs.openRead(is));
    }

    public XMLStreamReaderImpl(Reader r) throws XMLStreamException {
        this._reader = r;
        this.init();
    }

    public XMLStreamReaderImpl(InputStream is, String systemId) throws XMLStreamException {
        this(Vfs.openRead(is));
        this._systemId = systemId;
    }

    public XMLStreamReaderImpl(Reader reader, String systemId) throws XMLStreamException {
        this(reader);
        this._systemId = systemId;
    }

    public XMLStreamReaderImpl(ReadStream is) throws XMLStreamException {
        this._is = is;
        this.init();
    }

    public void init() throws XMLStreamException {
        this._namespaceTracker = new NamespaceReaderContext();
        this._intern = new StaxIntern(this._namespaceTracker);
        this._tempCharBuffer = TempCharBuffer.allocate();
        this._cBuf = this._tempCharBuffer.getBuffer();
        this._tempInputBuffer = TempCharBuffer.allocate();
        this._inputBuf = this._tempInputBuffer.getBuffer();
        this._inputLength = 0;
        this._inputOffset = 0;
        this.readHeader();
        this._current = 7;
    }

    public int available() {
        return this._inputLength - this._inputOffset;
    }

    @Override
    public int getAttributeCount() {
        return this._attrCount;
    }

    @Override
    public String getAttributeLocalName(int index) {
        if (this._attrCount <= index) {
            throw new IllegalArgumentException(L.l("element only has {0} attributes, given index {1}", this._attrCount, index));
        }
        return this._attrNames[index].getLocalPart();
    }

    @Override
    public QName getAttributeName(int index) {
        if (this._attrCount <= index) {
            throw new IllegalArgumentException(L.l("element only has {0} attributes, given index {1}", this._attrCount, index));
        }
        return this._attrNames[index];
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (this._attrCount <= index) {
            throw new IllegalArgumentException(L.l("element only has {0} attributes, given index {1}", this._attrCount, index));
        }
        String ret = this._attrNames[index].getNamespaceURI();
        if ("".equals(ret)) {
            return null;
        }
        return ret;
    }

    @Override
    public String getAttributePrefix(int index) {
        if (this._attrCount <= index) {
            throw new IllegalArgumentException(L.l("element only has {0} attributes, given index {1}", this._attrCount, index));
        }
        String ret = this._attrNames[index].getPrefix();
        return ret;
    }

    @Override
    public String getAttributeType(int index) {
        return "CDATA";
    }

    @Override
    public String getAttributeValue(int index) {
        if (this._attrCount <= index) {
            throw new IllegalArgumentException(L.l("element only has {0} attributes, given index {1}", this._attrCount, index));
        }
        return this._attrValues[index];
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return index < this._attrCount;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        for (int i = this._attrCount - 1; i >= 0; --i) {
            QName name = this._attrNames[i];
            if (!(namespaceURI == null ? name.getLocalPart().equals(localName) : name.getLocalPart().equals(localName) && name.getNamespaceURI().equals(namespaceURI))) continue;
            return this._attrValues[i];
        }
        return null;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this._encodingScheme;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this._current != 1) {
            throw new XMLStreamException(L.l("START_ELEMENT expected when calling getElementText()"));
        }
        StringBuilder sb = new StringBuilder();
        int eventType = this.next();
        while (eventType != 2) {
            switch (eventType) {
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    sb.append(this._cBuf, 0, this._cBufLength);
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 8: {
                    throw new XMLStreamException(L.l("Document ended unexpectedly while reading element text"));
                }
                case 1: {
                    throw new XMLStreamException(L.l("getElementText() encountered a START_ELEMENT; text only element expected"));
                }
                default: {
                    throw new XMLStreamException(L.l("Unexpected event during getElementText(): {0}", eventType));
                }
            }
            eventType = this.next();
        }
        return sb.toString();
    }

    @Override
    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public int getEventType() {
        return this._current;
    }

    @Override
    public Location getLocation() {
        return new StreamReaderLocation(this._offset, this._row, this._col);
    }

    @Override
    public String getLocalName() {
        if (this._name == null) {
            throw new IllegalStateException();
        }
        return this._name.getLocalPart();
    }

    @Override
    public String getNamespaceURI() {
        if (this._name == null) {
            return null;
        }
        String uri = this._name.getNamespaceURI();
        if ("".equals(uri)) {
            return null;
        }
        return uri.intern();
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this._namespaceTracker;
    }

    @Override
    public int getNamespaceCount() {
        return this._namespaceTracker.getNumDecls();
    }

    @Override
    public String getNamespacePrefix(int index) {
        String prefix = this._namespaceTracker.getPrefix(index);
        if ("".equals(prefix)) {
            return null;
        }
        return prefix;
    }

    @Override
    public String getNamespaceURI(int index) {
        return this._namespaceTracker.getUri(index);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this._namespaceTracker.getUri(prefix);
    }

    @Override
    public String getPIData() {
        if (this._current != 3) {
            return null;
        }
        return this._processingInstructionData;
    }

    @Override
    public String getPITarget() {
        if (this._current != 3) {
            return null;
        }
        return this._processingInstructionTarget;
    }

    @Override
    public String getPrefix() {
        if (this._name == null) {
            return null;
        }
        String prefix = this._name.getPrefix();
        if ("" == prefix && "" == this._name.getNamespaceURI()) {
            return null;
        }
        return prefix;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if ("javax.xml.stream.notations".equals(name)) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
        if ("javax.xml.stream.entities".equals(name)) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
        throw new IllegalArgumentException("property \"" + name + "+\" not supported");
    }

    @Override
    public String getText() {
        return new String(this._cBuf, 0, this._cBufLength);
    }

    @Override
    public char[] getTextCharacters() {
        return this._cBuf;
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        int sublen = this._cBufLength - sourceStart;
        if (length < sublen) {
            sublen = length;
        }
        System.arraycopy(this._cBuf, sourceStart, target, targetStart, sublen);
        return sublen;
    }

    @Override
    public int getTextLength() {
        return this._cBufLength;
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public boolean hasName() {
        return this._name != null;
    }

    @Override
    public boolean hasText() {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCharacters() {
        return this._current == 4;
    }

    @Override
    public boolean isEndElement() {
        if (this._current == 2) {
            return true;
        }
        return this._current == 1 && this._isShortTag;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean isStartElement() {
        return this._current == 1;
    }

    @Override
    public boolean isWhiteSpace() {
        return this._isWhitespace && (this._current == 4 || this._current == 6);
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int tag;
        while ((tag = this.next()) >= 0 && tag != 1 && tag != 2) {
        }
        return tag;
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (type != this._current) {
            StringBuilder sb = new StringBuilder();
            sb.append("expected ");
            sb.append(StaxUtil.constantToString(type));
            if (type == 1 || type == 2) {
                sb.append('(');
                sb.append(localName);
                sb.append(')');
            }
            sb.append(", found ");
            sb.append(StaxUtil.constantToString(this._current));
            if (this._current == 1 || this._current == 2) {
                sb.append('(');
                sb.append(this.getLocalName());
                sb.append(')');
            }
            sb.append(" at ");
            sb.append(this.getLocation());
            throw new XMLStreamException(sb.toString());
        }
        if (localName != null && !localName.equals(this.getLocalName())) {
            if (type == 1) {
                throw new XMLStreamException("expected <" + localName + ">, found <" + this.getLocalName() + "> at " + this.getLocation());
            }
            if (type == 2) {
                throw new XMLStreamException("expected </" + localName + ">, found </" + this.getLocalName() + "> at " + this.getLocation());
            }
        }
        if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("expected xmlns=" + namespaceURI + ", found xmlns=" + this.getNamespaceURI() + " at " + this.getLocation());
        }
    }

    @Override
    public boolean standaloneSet() {
        return this.isStandalone();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        if (this._is == null && this._reader == null) {
            return false;
        }
        return this._current != 8;
    }

    @Override
    public int next() throws XMLStreamException {
        try {
            this._current = this.readNext();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        if (this._current > 0) {
            return this._current;
        }
        if (this._eofEncountered) {
            this._current = -1;
        } else {
            this._eofEncountered = true;
            this._current = 8;
        }
        return this._current;
    }

    private int readNext() throws IOException, XMLStreamException {
        this._cBufLength = 0;
        if (this._current == 2) {
            this._namespaceTracker.pop();
        }
        if (this._isShortTag) {
            this._isShortTag = false;
            return 2;
        }
        this._name = null;
        int ch = this.read();
        if (ch == 60) {
            ch = this.read();
            switch (ch) {
                case 47: {
                    this._name = this.readName(false).getQName();
                    this.expect(62);
                    return 2;
                }
                case 33: {
                    this.expect(45);
                    this.expect(45);
                    return this.readComment();
                }
                case 63: {
                    this.readProcessingDirective();
                    return 3;
                }
                case -1: {
                    this.close();
                    return -1;
                }
            }
            this.unread();
            this.readElementBegin();
            return 1;
        }
        if (ch < 0) {
            this.close();
            return -1;
        }
        this.unread();
        return this.readData();
    }

    private void readElementBegin() throws IOException, XMLStreamException {
        this._namespaceTracker.push();
        StaxIntern.Entry eltName = this.readName(false);
        this._isShortTag = false;
        int ch = this.readAttributes();
        if (ch != 62) {
            if (ch == 47) {
                this._isShortTag = true;
                this.expect(62);
            } else {
                if (ch < 0) {
                    this.close();
                    return;
                }
                throw this.error(L.l("Expected {0} at {1}", (Object)">", (Object)this.charName(ch)));
            }
        }
        for (int i = this._attrCount - 1; i >= 0; --i) {
            this._attrNames[i] = this._attrRawNames[i].getQName();
        }
        this._name = eltName.getQName();
    }

    private int readAttributes() throws IOException, XMLStreamException {
        int ch;
        int attrCount = 0;
        while ((ch = this.skipWhitespace()) >= 0 && IS_XML_NAME[ch]) {
            this.unread();
            if (this._attrRawNames.length <= attrCount) {
                this.extendAttrs();
            }
            StaxIntern.Entry rawName = this.readName(true);
            ch = this.skipWhitespace();
            if (ch != 61) {
                throw this.error(L.l("attribute expects '=' at {0}", (Object)this.charName(ch)));
            }
            ch = this.skipWhitespace();
            if (ch == 39 || ch == 34) {
                if ("xmlns".equals(rawName.getPrefix())) {
                    this._namespaceTracker.declare(rawName.getLocalName(), this.readValue(ch));
                    continue;
                }
                if ("xmlns".equals(rawName.getLocalName())) {
                    this._namespaceTracker.declare("", this.readValue(ch));
                    continue;
                }
                this._attrRawNames[attrCount] = rawName;
                this._attrValues[attrCount++] = this.readValue(ch);
                continue;
            }
            throw this.error(L.l("attribute expects value at {0}", (Object)this.charName(ch)));
        }
        this._attrCount = attrCount;
        return ch;
    }

    private String readValue(int end) throws XMLStreamException {
        char[] valueBuffer = this._cBuf;
        int valueIndex = 0;
        block5: while (true) {
            int ch = this.read();
            switch (ch) {
                case -1: {
                    return new String(valueBuffer, 0, valueIndex);
                }
                case 34: 
                case 39: {
                    if (ch == end) {
                        return new String(valueBuffer, 0, valueIndex);
                    }
                    valueBuffer[valueIndex++] = (char)ch;
                    continue block5;
                }
                case 38: {
                    valueBuffer[valueIndex++] = (char)ch;
                    continue block5;
                }
            }
            valueBuffer[valueIndex++] = (char)ch;
        }
    }

    private void extendAttrs() {
        int length = this._attrRawNames.length;
        StaxIntern.Entry[] attrRawNames = new StaxIntern.Entry[length + 16];
        System.arraycopy(this._attrRawNames, 0, attrRawNames, 0, length);
        this._attrRawNames = attrRawNames;
        QName[] attrNames = new QName[length + 16];
        System.arraycopy(this._attrNames, 0, attrNames, 0, length);
        this._attrNames = attrNames;
        String[] attrValues = new String[length + 16];
        System.arraycopy(this._attrValues, 0, attrValues, 0, length);
        this._attrValues = attrValues;
    }

    private int readData() throws IOException, XMLStreamException {
        int index;
        int ch = 0;
        this._isWhitespace = true;
        char[] cBuf = this._cBuf;
        int length = cBuf.length;
        int entity = -1;
        block7: for (index = 0; index < length && (ch = this.read()) >= 0; ++index) {
            switch (ch) {
                case 60: {
                    this.unread();
                    break block7;
                }
                case 38: {
                    if (cBuf.length <= index + 256) {
                        this.unread();
                        break block7;
                    }
                    cBuf[index] = (char)ch;
                    entity = index;
                    continue block7;
                }
                case 13: {
                    ch = this.read();
                    if (ch != 10) {
                        ch = 13;
                        this.unread();
                    }
                }
                case 9: 
                case 10: 
                case 32: {
                    cBuf[index] = (char)ch;
                    continue block7;
                }
                case 59: {
                    if (entity >= 0) {
                        String unresolved = new String(cBuf, entity + 1, index - entity - 1);
                        String resolved = this.resolveEntity(unresolved);
                        index = entity + resolved.length() - 1;
                        resolved.getChars(0, resolved.length(), cBuf, entity);
                        entity = -1;
                        continue block7;
                    }
                }
                default: {
                    this._isWhitespace = false;
                    cBuf[index] = (char)ch;
                }
            }
        }
        if (entity > 0) {
            throw new XMLStreamException("XXX: unclosed entity at end of file");
        }
        this._cBufLength = index;
        if (ch < 0 && this._isWhitespace) {
            return -1;
        }
        boolean isIgnorableWhitespace = this._isWhitespace && this._namespaceTracker.getDepth() == 0;
        return isIgnorableWhitespace ? 6 : 4;
    }

    private String resolveEntity(String s) throws XMLStreamException {
        if ("amp".equals(s)) {
            return "&";
        }
        if ("apos".equals(s)) {
            return "'";
        }
        if ("quot".equals(s)) {
            return "\"";
        }
        if ("lt".equals(s)) {
            return "<";
        }
        if ("gt".equals(s)) {
            return ">";
        }
        if (s.startsWith("#x")) {
            return "" + (char)Integer.parseInt(s.substring(2), 16);
        }
        if (s.startsWith("#")) {
            return "" + (char)Integer.parseInt(s.substring(1));
        }
        throw new XMLStreamException("unknown entity: \"" + s + "\"");
    }

    private void readProcessingDirective() throws XMLStreamException {
        CharBuffer target = new CharBuffer();
        CharBuffer data = null;
        int ch;
        while ((ch = this.read()) != -1) {
            if (ch == 63) {
                int next = this.read();
                if (next == 62) {
                    this._processingInstructionTarget = target.toString();
                    this._processingInstructionData = data == null ? null : data.toString();
                    return;
                }
                this.unread();
            }
            if (data == null && (ch == 32 || ch == 13 || ch == 10)) {
                data = new CharBuffer();
                continue;
            }
            if (data != null) {
                data.append((char)ch);
                continue;
            }
            target.append((char)ch);
        }
        return;
    }

    private int readComment() throws XMLStreamException {
        int index;
        int ch = 0;
        char[] cBuf = this._cBuf;
        int length = cBuf.length;
        for (index = 0; index < length && (ch = this.read()) >= 0; ++index) {
            cBuf[index] = (char)ch;
            if (index <= 3 || cBuf[index - 2] != '-' || cBuf[index - 1] != '-' || cBuf[index - 0] != '>') continue;
            index -= 2;
            break;
        }
        this._cBufLength = index;
        return 5;
    }

    private void readRawName(RawName name) throws IOException, XMLStreamException {
        int ch;
        int length = 0;
        char[] nameBuffer = name._buffer;
        int bufferLength = nameBuffer.length;
        int prefix = -1;
        while ((ch = this.read()) >= 0 && IS_XML_NAME[ch]) {
            if (bufferLength <= length) {
                name.expandCapacity();
                nameBuffer = name._buffer;
                bufferLength = nameBuffer.length;
            }
            if (ch == 58 && prefix < 0) {
                prefix = length;
            }
            nameBuffer[length++] = (char)ch;
        }
        this.unread();
        name._length = length;
        name._prefix = prefix;
    }

    private StaxIntern.Entry readName(boolean isAttribute) throws XMLStreamException {
        char[] inputBuf = this._inputBuf;
        int inputLength = this._inputLength;
        int inputOffset = this._inputOffset;
        char[] valueBuf = this._cBuf;
        int valueOffset = 0;
        int colon = 0;
        while (true) {
            if (inputOffset < inputLength) {
                char ch;
                if (IS_XML_NAME[ch = inputBuf[inputOffset++]]) {
                    valueBuf[valueOffset++] = ch;
                    continue;
                }
                if (ch == ':') {
                    if (colon <= 0) {
                        colon = valueOffset;
                    }
                    valueBuf[valueOffset++] = ch;
                    continue;
                }
                this._inputOffset = inputOffset - 1;
                return this._intern.add(valueBuf, 0, valueOffset, colon, isAttribute);
            }
            if (!this.fillBuffer()) break;
            inputLength = this._inputLength;
            inputOffset = this._inputOffset;
        }
        return this._intern.add(valueBuf, 0, valueOffset, colon, isAttribute);
    }

    private static boolean isXmlName(int ch) {
        return 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57 || ch == 58 || ch == 43 || ch == 95 || ch == 45;
    }

    private int skipWhitespace() throws XMLStreamException {
        int ch;
        while ((ch = this.read()) == 32 || ch == 9 || ch == 13 || ch == 10) {
        }
        return ch;
    }

    private void readHeader() throws XMLStreamException {
        int ch = this.readByte();
        if (ch == 254) {
            if (this.readByte() != 255) {
                throw new XMLStreamException("found unrecognized BOM");
            }
            ch = this.readByte();
        } else if (ch == 255) {
            if (this.readByte() != 254) {
                throw new UnsupportedOperationException("found byte-swapped BOM");
            }
            throw new XMLStreamException("found unrecognized BOM");
        }
        if (ch != 60) {
            this.unreadByte();
        } else {
            ch = this.readByte();
            if (ch != 63) {
                this.unreadByte();
                this.unreadByte();
            } else {
                ch = this.readByte();
                if (ch != 120) {
                    this.unreadByte();
                    this.unreadByte();
                    this.unreadByte();
                } else {
                    ch = this.readByte();
                    if (ch != 109) {
                        this.unreadByte();
                        this.unreadByte();
                        this.unreadByte();
                        this.unreadByte();
                    } else {
                        ch = this.readByte();
                        if (ch != 108) {
                            this.unreadByte();
                            this.unreadByte();
                            this.unreadByte();
                            this.unreadByte();
                            this.unreadByte();
                        } else {
                            char quot;
                            CharBuffer directive = new CharBuffer();
                            while ((ch = this.readByte()) >= 0 && ch != 63) {
                                directive.append((char)ch);
                            }
                            String data = directive.toString().trim();
                            if (data.startsWith("version")) {
                                data = data.substring(7).trim();
                                data = data.substring(1).trim();
                                quot = data.charAt(0);
                                this._version = data.substring(1, data.indexOf(quot, 1));
                                data = data.substring(data.indexOf(quot, 1) + 1).trim();
                            }
                            if (data.startsWith("encoding")) {
                                data = data.substring(8).trim();
                                data = data.substring(1).trim();
                                quot = data.charAt(0);
                                this._encoding = data.substring(1, data.indexOf(quot, 1));
                                data = data.substring(data.indexOf(quot, 1) + 1).trim();
                                try {
                                    if (this._is != null) {
                                        this._is.setEncoding(this._encoding);
                                    }
                                }
                                catch (UnsupportedEncodingException e) {
                                    throw new XMLStreamException(e);
                                }
                            }
                            if ((ch = this.readByte()) != 62) {
                                throw this.error(L.l("Expected '>' at end of '<?xml' declaration at {0}", (Object)this.charName(ch)));
                            }
                        }
                    }
                }
            }
        }
        this.skipWhitespace();
        this.unread();
    }

    private void expect(int expect) throws XMLStreamException {
        int ch = this.read();
        if (ch != expect) {
            throw this.error(L.l("expected {0} at {1}", (Object)this.charName(expect), (Object)this.charName(ch)));
        }
    }

    private int read() throws XMLStreamException {
        if (this._inputLength <= this._inputOffset && !this.fillBuffer()) {
            return -1;
        }
        char ch = this._inputBuf[this._inputOffset++];
        ++this._offset;
        if (ch == '\n') {
            ++this._row;
            this._lastCol = this._col;
            this._col = 1;
        } else {
            ++this._col;
        }
        return ch;
    }

    private void unread() {
        if (this._inputOffset > 0) {
            --this._inputOffset;
            --this._offset;
            if (this._col > 1) {
                --this._col;
            }
            if (this._inputBuf[this._inputOffset] == '\n') {
                --this._row;
                this._col = this._lastCol;
            }
        }
    }

    private int readByte() throws XMLStreamException {
        try {
            if (this._inputLength <= this._inputOffset) {
                int ch = -1;
                if (this._is != null) {
                    ch = this._is.read();
                } else if (this._reader != null) {
                    ch = this._reader.read();
                }
                if (ch < 0) {
                    return ch;
                }
                if (this._inputBuf.length <= this._inputLength) {
                    this._inputLength = 0;
                }
                this._inputBuf[this._inputLength++] = (char)ch;
                this._inputOffset = this._inputLength;
                ++this._offset;
                if (ch == 10) {
                    ++this._row;
                    this._col = 1;
                } else {
                    ++this._col;
                }
                return ch;
            }
            return this._inputBuf[this._inputOffset++];
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void unreadByte() {
        if (this._inputOffset > 0) {
            --this._inputOffset;
        }
    }

    private final boolean fillBuffer() throws XMLStreamException {
        try {
            if (this._is != null) {
                this._inputOffset = 0;
                this._inputLength = this._is.read(this._inputBuf, 0, this._inputBuf.length);
                return this._inputLength > 0;
            }
            if (this._reader != null) {
                this._inputOffset = 0;
                this._inputLength = this._reader.read(this._inputBuf, 0, this._inputBuf.length);
                return this._inputLength > 0;
            }
            this._inputOffset = 0;
            this._inputLength = 0;
            return false;
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private String charName(int ch) {
        if (ch < 0) {
            return "end of file";
        }
        if (ch > 32 && ch <= 127) {
            return "'" + (char)ch + "'";
        }
        return "0x" + Integer.toHexString(ch);
    }

    private XMLStreamException error(String s) {
        return new XMLStreamException(this.location() + s);
    }

    private String location() {
        return ":" + this._row + ":" + this._col + " ";
    }

    @Override
    public void close() throws XMLStreamException {
        TempCharBuffer tempCharBuffer = this._tempCharBuffer;
        this._tempCharBuffer = null;
        this._cBuf = null;
        TempCharBuffer tempInputBuffer = this._tempInputBuffer;
        this._tempInputBuffer = null;
        this._inputBuf = null;
        this._inputLength = 0;
        this._inputOffset = 0;
        if (tempCharBuffer != null) {
            TempCharBuffer.free(tempCharBuffer);
        }
        if (tempInputBuffer != null) {
            TempCharBuffer.free(tempInputBuffer);
        }
        ReadStream is = this._is;
        this._is = null;
        if (is != null) {
            is.close();
        }
        Reader r = this._reader;
        this._reader = null;
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    static {
        for (int i = 0; i < IS_XML_NAME.length; ++i) {
            if (!XMLStreamReaderImpl.isXmlName(i) || i == 58) continue;
            XMLStreamReaderImpl.IS_XML_NAME[i] = XMLStreamReaderImpl.isXmlName(i);
        }
    }

    private class StreamReaderLocation
    implements Location {
        private int _offset;
        private int _row;
        private int _col;

        public StreamReaderLocation(int ofs, int row, int col) {
            this._offset = ofs;
            this._row = row;
            this._col = col;
        }

        @Override
        public int getCharacterOffset() {
            return this._offset;
        }

        @Override
        public int getColumnNumber() {
            return this._col;
        }

        @Override
        public int getLineNumber() {
            return this._row;
        }

        @Override
        public String getPublicId() {
            return XMLStreamReaderImpl.this._publicId;
        }

        @Override
        public String getSystemId() {
            return XMLStreamReaderImpl.this._systemId;
        }

        public String toString() {
            return this._row + ":" + this._col;
        }
    }

    static class RawName {
        char[] _buffer = new char[64];
        int _prefix;
        int _length;

        RawName() {
        }

        public QName resolve(NamespaceContext nsc) {
            if (this.getPrefix() == null) {
                return new QName(nsc.getNamespaceURI(null), this.getLocalName());
            }
            return new QName(nsc.getNamespaceURI(this.getPrefix()), this.getLocalName(), this.getPrefix());
        }

        public String toString() {
            return new String(this._buffer, 0, this._length);
        }

        String getLocalName() {
            return new String(this._buffer, this._prefix + 1, this._length - this._prefix - 1);
        }

        String getPrefix() {
            if (this._prefix == -1) {
                return null;
            }
            return new String(this._buffer, 0, this._prefix);
        }

        void expandCapacity() {
            char[] newBuffer = new char[this._buffer.length + 64];
            System.arraycopy(this._buffer, 0, newBuffer, 0, this._buffer.length);
            this._buffer = newBuffer;
        }
    }
}

