/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import org.w3c.dom.Node;

public class FromContext
extends Axis {
    int _ancestorCount;

    public FromContext() {
        super(null);
    }

    public FromContext(int ancestorCount) {
        super(null);
        this._ancestorCount = ancestorCount;
    }

    public int getCount() {
        return this._ancestorCount;
    }

    @Override
    public boolean match(Node node, ExprEnvironment env) {
        Node context = env.getContextNode();
        for (int i = 0; i < this._ancestorCount && context != null; context = context.getParentNode(), ++i) {
        }
        return node == context;
    }

    @Override
    public boolean isStrictlyAscending() {
        return true;
    }

    @Override
    boolean isSingleSelect() {
        return true;
    }

    @Override
    public int position(Node node, Env env, AbstractPattern pattern) {
        return 1;
    }

    @Override
    public int count(Node node, Env env, AbstractPattern pattern) {
        return 1;
    }

    @Override
    public Node firstNode(Node node, ExprEnvironment env) {
        for (int i = 0; node != null && i < this._ancestorCount; node = node.getParentNode(), ++i) {
        }
        return node;
    }

    @Override
    public Node nextNode(Node node, Node lastNode) {
        return null;
    }

    public boolean equals(Object b) {
        return b instanceof FromContext && this._ancestorCount == ((FromContext)b)._ancestorCount;
    }

    public String toString() {
        if (this._ancestorCount == 0) {
            return "context()";
        }
        CharBuffer cb = CharBuffer.allocate();
        cb.append("..");
        for (int i = 1; i < this._ancestorCount; ++i) {
            cb.append("/..");
        }
        return cb.close();
    }
}

