/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeClassMatcher;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class ByteCodeClassScanner {
    private static final Logger log = Logger.getLogger(ByteCodeClassScanner.class.getName());
    private static final L10N L = new L10N(ByteCodeClassScanner.class);
    private static final char[] RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations".toCharArray();
    private static final boolean[] IS_JAVA_IDENTIFIER = new boolean[65536];
    private String _className;
    private InputStream _is;
    private ByteCodeClassMatcher _matcher;
    private char[] _charBuffer = new char[16384];
    private int _charBufferOffset;
    private int _cpCount;
    private int[] _cpData;
    private int[] _cpLengths;
    private int[] _classData;

    public void init(String className, InputStream is, ByteCodeClassMatcher matcher) {
        this._className = className;
        this._is = is;
        this._matcher = matcher;
        this._charBufferOffset = 0;
    }

    public boolean scan() {
        try {
            String className;
            InputStream is = this._is;
            int magic = this.readInt(is);
            if (magic != -889275714) {
                throw this.error(L.l("bad magic number in class file"));
            }
            is.skip(2L);
            is.skip(2L);
            this.parseConstantPool(is);
            int modifiers = this.readShort(is);
            int thisClassIndex = this.readShort(is);
            int cpIndex = this._classData[thisClassIndex];
            if (cpIndex > 0 && !this._matcher.scanClass(className = new String(this._charBuffer, this._cpData[cpIndex], this._cpLengths[cpIndex]), modifiers)) {
                return false;
            }
            int superClassIndex = this.readShort(is);
            if (superClassIndex > 0 && (cpIndex = this._classData[superClassIndex]) > 0) {
                this._matcher.addSuperClass(this._charBuffer, this._cpData[cpIndex], this._cpLengths[cpIndex]);
            }
            int interfaceCount = this.readShort(is);
            for (int i = 0; i < interfaceCount; ++i) {
                int classIndex = this.readShort(is);
                cpIndex = this._classData[classIndex];
                if (cpIndex <= 0) continue;
                this._matcher.addInterface(this._charBuffer, this._cpData[cpIndex], this._cpLengths[cpIndex]);
            }
            int fieldCount = this.readShort(is);
            for (int i = 0; i < fieldCount; ++i) {
                this.scanField(is);
            }
            int methodCount = this.readShort(is);
            for (int i = 0; i < methodCount; ++i) {
                this.scanMethod(is);
            }
            int attrCount = this.readShort(is);
            for (int i = 0; i < attrCount; ++i) {
                this.scanClassAttribute(is);
            }
            char[] charBuffer = this._charBuffer;
            for (int i = 0; i < this._cpCount; ++i) {
                int cpOffset;
                int cpLength = this._cpLengths[i];
                if (cpLength <= 0 || charBuffer[cpOffset = this._cpData[i]] != 'L' || charBuffer[cpOffset + cpLength - 1] != ';') continue;
                this._matcher.addPoolString(charBuffer, cpOffset + 1, cpLength - 2);
            }
            return this._matcher.finishScan();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "failed scanning class " + this._className + "\n" + e.toString(), e);
            return false;
        }
    }

    public boolean parseConstantPool(InputStream is) throws IOException {
        int count;
        this._cpCount = count = this.readShort(is);
        if (this._cpData == null || this._cpData.length <= count) {
            this._cpData = new int[count];
            this._cpLengths = new int[count];
            this._classData = new int[count];
        }
        Arrays.fill(this._cpData, 0);
        Arrays.fill(this._cpLengths, 0);
        Arrays.fill(this._classData, 0);
        int i = 1;
        block16: while (i < count) {
            int index = i++;
            int code = is.read();
            if (code == 5 || code == 6) {
                i += 2;
            }
            switch (code) {
                case 7: {
                    int utf8Index;
                    this._classData[index] = utf8Index = this.readShort(is);
                    continue block16;
                }
                case 9: {
                    is.skip(4L);
                    continue block16;
                }
                case 10: {
                    is.skip(4L);
                    continue block16;
                }
                case 11: {
                    is.skip(4L);
                    continue block16;
                }
                case 8: {
                    is.skip(2L);
                    continue block16;
                }
                case 3: {
                    is.skip(4L);
                    continue block16;
                }
                case 4: {
                    is.skip(4L);
                    continue block16;
                }
                case 5: {
                    is.skip(8L);
                    continue block16;
                }
                case 6: {
                    is.skip(8L);
                    continue block16;
                }
                case 12: {
                    is.skip(4L);
                    continue block16;
                }
                case 1: {
                    int length = this.readShort(is);
                    this._cpData[index] = this._charBufferOffset;
                    this._cpLengths[index] = this.parseUtf8(is, length);
                    continue block16;
                }
                case 15: {
                    is.skip(3L);
                    continue block16;
                }
                case 16: {
                    is.skip(2L);
                    continue block16;
                }
                case 18: {
                    is.skip(4L);
                    continue block16;
                }
            }
            throw this.error(L.l("'{0}' is an unknown constant pool type.", code));
        }
        return false;
    }

    private int parseUtf8(InputStream is, int length) throws IOException {
        char[] buffer;
        if (length <= 0) {
            return 0;
        }
        if (length > 256) {
            is.skip(length);
            return 0;
        }
        int offset = this._charBufferOffset;
        if (this._charBuffer.length <= offset + length) {
            buffer = new char[2 * this._charBuffer.length];
            System.arraycopy(this._charBuffer, 0, buffer, 0, this._charBuffer.length);
            this._charBuffer = buffer;
        }
        buffer = this._charBuffer;
        boolean[] isJavaIdentifier = IS_JAVA_IDENTIFIER;
        boolean isIdentifier = true;
        while (length > 0) {
            int d2;
            int ch;
            int d1 = is.read();
            if (d1 == 47) {
                ch = 46;
                --length;
            } else if (d1 < 128) {
                ch = (char)d1;
                --length;
            } else if (d1 < 224) {
                d2 = is.read() & 0x3F;
                ch = (char)(((d1 & 0x1F) << 6) + d2);
                length -= 2;
            } else if (d1 < 240) {
                d2 = is.read() & 0x3F;
                int d3 = is.read() & 0x3F;
                ch = (char)(((d1 & 0xF) << 12) + (d2 << 6) + d3);
                length -= 3;
            } else {
                throw this.error("invalid UTF-8 code: 0x" + Integer.toHexString(d1));
            }
            if (isIdentifier && isJavaIdentifier[ch]) {
                buffer[offset++] = ch;
                continue;
            }
            isIdentifier = false;
        }
        if (!isIdentifier) {
            return 0;
        }
        int charLength = offset - this._charBufferOffset;
        this._charBufferOffset = offset;
        return charLength;
    }

    private void scanField(InputStream is) throws IOException {
        is.skip(6L);
        int attributesCount = this.readShort(is);
        for (int i = 0; i < attributesCount; ++i) {
            this.scanAttributeForAnnotation(is);
        }
    }

    private void scanMethod(InputStream is) throws IOException {
        is.skip(6L);
        int attributesCount = this.readShort(is);
        for (int i = 0; i < attributesCount; ++i) {
            this.scanAttributeForAnnotation(is);
        }
    }

    private void scanClassAttribute(InputStream is) throws IOException {
        int nameIndex = this.readShort(is);
        int length = this.readInt(is);
        if (!this.isNameAnnotation(nameIndex)) {
            is.skip(length);
            return;
        }
        int count = this.readShort(is);
        for (int i = 0; i < count; ++i) {
            int annTypeIndex = this.scanAnnotation(is);
            if (annTypeIndex <= 0) continue;
            this._matcher.addClassAnnotation(this._charBuffer, this._cpData[annTypeIndex] + 1, this._cpLengths[annTypeIndex] - 2);
        }
    }

    private void scanAttributeForAnnotation(InputStream is) throws IOException {
        int nameIndex = this.readShort(is);
        int length = this.readInt(is);
        if (!this.isNameAnnotation(nameIndex)) {
            is.skip(length);
            return;
        }
        int count = this.readShort(is);
        for (int i = 0; i < count; ++i) {
            int annTypeIndex = this.scanAnnotation(is);
            if (annTypeIndex <= 0 || this._cpLengths[annTypeIndex] <= 2) continue;
            this._matcher.addClassAnnotation(this._charBuffer, this._cpData[annTypeIndex] + 1, this._cpLengths[annTypeIndex] - 2);
        }
    }

    private int scanAnnotation(InputStream is) throws IOException {
        int typeIndex = this.readShort(is);
        int valueCount = this.readShort(is);
        for (int j = 0; j < valueCount; ++j) {
            is.skip(2L);
            this.skipElementValue(is);
        }
        return typeIndex;
    }

    private void skipElementValue(InputStream is) throws IOException {
        int code = is.read();
        switch (code) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                is.skip(2L);
                return;
            }
            case 101: {
                is.skip(4L);
                return;
            }
            case 99: {
                is.skip(2L);
                return;
            }
            case 64: {
                this.scanAnnotation(is);
                return;
            }
            case 91: {
                int len = this.readShort(is);
                for (int i = 0; i < len; ++i) {
                    this.skipElementValue(is);
                }
                return;
            }
        }
        throw this.error("unknown code: " + (char)code);
    }

    private boolean isNameAnnotation(int nameIndex) {
        if (nameIndex <= 0) {
            return false;
        }
        int offset = this._cpData[nameIndex];
        int length = this._cpLengths[nameIndex];
        char[] charBuffer = this._charBuffer;
        if (length != RUNTIME_VISIBLE_ANNOTATIONS.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (charBuffer[i + offset] == RUNTIME_VISIBLE_ANNOTATIONS[i]) continue;
            return false;
        }
        return true;
    }

    private int readInt(InputStream is) throws IOException {
        return is.read() << 24 | is.read() << 16 | is.read() << 8 | is.read();
    }

    private int readShort(InputStream is) throws IOException {
        int c1 = is.read();
        int c2 = is.read();
        return c1 << 8 | c2;
    }

    private IllegalStateException error(String message) {
        return new IllegalStateException(this._className + ": " + message + " [" + this._is + "]");
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            if (!Character.isJavaIdentifierPart(i) && i != 46 && i != 59) continue;
            ByteCodeClassScanner.IS_JAVA_IDENTIFIER[i] = true;
        }
    }
}

