/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.InjectScanManager;
import com.caucho.inject.Jndi;
import com.caucho.inject.MBean;
import com.caucho.loader.enhancer.ScanClass;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.sql.DataSourceDefinition;
import javax.decorator.Delegate;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Stereotype;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;

class InjectScanClass
implements ScanClass {
    private static final Logger log = Logger.getLogger(InjectScanClass.class.getName());
    private static final char[] PRODUCES = Produces.class.getName().toCharArray();
    private static final char[] DISPOSES = Disposes.class.getName().toCharArray();
    private static final char[] OBSERVES = Observes.class.getName().toCharArray();
    private static final char[] OBJECT = Object.class.getName().toCharArray();
    private static final HashSet<Class<?>> _registerAnnotationSet = new HashSet();
    private static final HashSet<Class<?>> _immediateResourceSet = new HashSet();
    private final String _className;
    private final InjectScanManager _scanManager;
    private InjectScanClass _parent;
    private ArrayList<InjectScanClass> _children;
    private boolean _isScanClass;
    private boolean _isRegisterRequired;
    private boolean _isRegistered;
    private boolean _isObserves;

    InjectScanClass(String className, InjectScanManager manager) {
        this._className = className;
        this._scanManager = manager;
    }

    public String getClassName() {
        return this._className;
    }

    public void setScanClass() {
        this._isScanClass = true;
    }

    public boolean isScanClass() {
        return this._isScanClass;
    }

    public boolean isRegisterRequired() {
        return this._isRegisterRequired;
    }

    public boolean isRegistered() {
        return this._isRegistered;
    }

    public boolean isObserves() {
        return this._isObserves;
    }

    @Override
    public void addInterface(char[] buffer, int offset, int length) {
        this.addParent(new String(buffer, offset, length));
    }

    @Override
    public void addSuperClass(char[] buffer, int offset, int length) {
        if (this.isMatch(buffer, offset, length, OBJECT)) {
            return;
        }
        this.addParent(new String(buffer, offset, length));
    }

    @Override
    public void addClassAnnotation(char[] buffer, int offset, int length) {
        try {
            InjectScanManager.AnnType annType = this._scanManager.loadAnnotation(buffer, offset, length);
            if (annType == null) {
                return;
            }
            if (annType.getType() == Observes.class) {
                this.setObserves();
            }
            if (this._isRegisterRequired) {
                if (_immediateResourceSet.contains(annType.getType())) {
                    this._scanManager.addImmediateResource(this);
                }
                return;
            }
            if (_registerAnnotationSet.contains(annType.getType())) {
                this._isRegisterRequired = true;
                return;
            }
            for (Annotation ann : annType.getAnnotations()) {
                Class<? extends Annotation> metaAnnType = ann.annotationType();
                if (metaAnnType == Stereotype.class) {
                    this._isRegisterRequired = true;
                    continue;
                }
                if (metaAnnType == Scope.class) {
                    this._isRegisterRequired = true;
                    continue;
                }
                if (metaAnnType != NormalScope.class) continue;
                this._isRegisterRequired = true;
            }
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    private void setObserves() {
        this._isObserves = true;
        this._isRegisterRequired = true;
        if (this._children != null) {
            for (InjectScanClass scanClass : this._children) {
                scanClass.setObserves();
            }
        }
    }

    @Override
    public void addPoolString(char[] buffer, int offset, int length) {
        if (this.isMatch(buffer, offset, length, PRODUCES)) {
            this._isRegisterRequired = true;
        } else if (this.isMatch(buffer, offset, length, DISPOSES)) {
            this._isRegisterRequired = true;
        } else if (this.isMatch(buffer, offset, length, OBSERVES)) {
            this.setObserves();
        }
    }

    @Override
    public boolean finishScan() {
        if (this._isRegisterRequired || this._scanManager.isCustomExtension() || this._parent != null && this._parent.isRegistered()) {
            this.register();
        }
        return true;
    }

    private void addParent(String className) {
        InjectScanClass parent = this._scanManager.createScanClass(className);
        parent.addChild(this);
        if (this._parent == null) {
            this._parent = parent;
        }
    }

    private void addChild(InjectScanClass child) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        if (!this._children.contains(child)) {
            this._children.add(child);
        }
        if (this._isObserves) {
            child.setObserves();
        }
    }

    void register() {
        if (this._isScanClass && !this._isRegistered) {
            this._isRegistered = true;
            this._scanManager.addDiscoveredClass(this);
        }
        if (this._children != null) {
            for (InjectScanClass child : this._children) {
                child.register();
            }
        }
    }

    private boolean isMatch(char[] buffer, int offset, int length, char[] matchBuffer) {
        if (length != matchBuffer.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (buffer[offset + i] == matchBuffer[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._className + "]";
    }

    static {
        _registerAnnotationSet.add(Inject.class);
        _registerAnnotationSet.add(Named.class);
        _registerAnnotationSet.add(Specializes.class);
        _registerAnnotationSet.add(Delegate.class);
        _registerAnnotationSet.add(Startup.class);
        _registerAnnotationSet.add(Jndi.class);
        _registerAnnotationSet.add(MBean.class);
        _registerAnnotationSet.add(Stateless.class);
        _registerAnnotationSet.add(Stateful.class);
        _registerAnnotationSet.add(Singleton.class);
        _registerAnnotationSet.add(MessageDriven.class);
        _registerAnnotationSet.add(Qualifier.class);
        _registerAnnotationSet.add(DataSourceDefinition.class);
        _immediateResourceSet.add(DataSourceDefinition.class);
    }
}

