/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.io;

import com.caucho.db.io.InStore;
import com.caucho.db.io.OutStore;
import com.caucho.db.io.StoreBuilder;
import com.caucho.db.io.StoreReadWrite;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.RandomAccessStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class RandomAccessStreamNio
extends RandomAccessStream {
    private static final L10N L = new L10N(RandomAccessStreamNio.class);
    private static final Logger log = Logger.getLogger(RandomAccessStreamNio.class.getName());
    private final Path _path;
    private StoreReadWrite _store;

    private RandomAccessStreamNio(Path path, StoreReadWrite store) {
        this._path = path;
        this._store = store;
    }

    public static RandomAccessStreamNio open(Path path, long fileLength) throws IOException {
        long currentFileLength = path.getLength();
        fileLength = Math.max(fileLength, currentFileLength);
        StoreBuilder builder = new StoreBuilder(path);
        StoreReadWrite store = builder.build();
        if (path.exists()) {
            store.init();
        } else {
            store.create();
        }
        return new RandomAccessStreamNio(path, store);
    }

    @Override
    public boolean isMmap() {
        return false;
    }

    @Override
    public long getLength() throws IOException {
        return this._store.getFileSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(long pos, byte[] buf, int offset, int length) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        InStore is = null;
        try {
            if (!this.allocate()) {
                int n = -1;
                return n;
            }
            is = this._store.openRead(pos, length);
            if (is.read(pos, buf, offset, length)) {
                int n = length;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.free();
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long pos, byte[] buf, int offset, int length) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException(L.l("pos: 0x{0} offset: 0x{1} length: 0x{2} buf.len: 0x{3}", (Object)Long.toHexString(pos), (Object)Long.toHexString(offset), (Object)Long.toHexString(length), (Object)Long.toHexString(buf.length)));
        }
        if (pos < 0L) {
            throw new ArrayIndexOutOfBoundsException();
        }
        OutStore os = null;
        try {
            if (!this.allocate()) {
                return;
            }
            os = this._store.openWrite(pos, length);
            os.write(pos, buf, offset, length);
        }
        finally {
            this.free();
        }
    }

    @Override
    public void fsync() throws IOException {
        this.flushToDisk();
    }

    public void flushToDisk() throws IOException {
        try {
            if (this.allocate()) {
                this._store.fsync();
            }
        }
        finally {
            this.free();
        }
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int read(char[] buf, int offset, int length) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean seek(long position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public long getFilePointer() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected void closeImpl() throws IOException {
        StoreReadWrite store;
        if (this.getUseCount() > 0L) {
            log.warning(this + " free with use " + this.getUseCount());
            System.err.println(this + " DOUBLE_CLOSE: " + this.getUseCount());
        }
        if ((store = this._store) != null) {
            store.close();
        }
        super.closeImpl();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._path + "]";
    }
}

